import React, { useState } from 'react';
import { useNavigate } from 'react-router-dom'
import { API_Login } from '@/api'
import { Form, Button, Input, message } from 'antd'
import 'antd/dist/antd.css'
import { UserOutlined, LockOutlined } from '@ant-design/icons';
import './index.css'
const STYLE = {
  container: {
    width: "100%",
    height: "100%",
    textAlign: 'center',
    backgroundImage: "url(../../public/img/1.png)",
    bgContent: {
      width: "60%",
      height: "100%",
      float: "left",
      marginLeft: "20%",
      paddingTop: "10%",
      textAlign: "left",
      img: {
        width: "80%",
        marginLeft: "10%"
      },
      form: {
        width: "60%",
        marginTop: "50px",
        marginLeft: "20%",
        color: "white",
        item: {
          height: "50px",
          input: {
            height: "50px",
            color: "whtie !important",
            // backgroundColor: "#ddd",
            icon: {
              width: "30px",
              color: "white"
            }
          },
          button: {
            height: "50px",
            marginTop: "20px",
            fontSize: "28px",
            fontWeight: "600",
            letterSpacing: "15px",
            border: "none",
            color: "white",
            borderRadius: "10px",
            background: "none",
            backgroundImage: "url(../../public/img/3.png)",
            backgroundRepeat: "no-repeat",
            backgroundSize: "100% 100%"
          }
        },

      }
    }
  }
}

export default function login() {
  const [username, setUsername] = useState('');
  const [password, setPassword] = useState('');

  const navigate = useNavigate();
  const handleClick = (path) => {
    // debugger
    // API_Login(username, password).then(res => {
    //   sessionStorage.setItem("username", username);
    //   sessionStorage.setItem("password", password);
    //   message.success('登录成功');
    //   sessionStorage.setItem("token", res);
    //   sessionStorage.setItem("login", true);
    //   sessionStorage.removeItem("openKeys");
    //   sessionStorage.removeItem("selectKeys");
    //   navigate(path);
    // }).catch(err => {
    //   message.warn(err);
    // });

    sessionStorage.setItem("username", username);
    sessionStorage.setItem("password", password);
    message.success('登录成功');
    // sessionStorage.setItem("token", res);
    sessionStorage.setItem("login", true);
    sessionStorage.removeItem("openKeys");
    sessionStorage.removeItem("selectKeys");
    navigate(path);
  }

  return (
    <div className='login' style={STYLE.container}>
      <div style={STYLE.container.bgContent}>
        <img src='../../public/img/2.png' style={STYLE.container.bgContent.img}></img>
        <Form
          name="basic"
          labelCol={{ span: 4 }}
          wrapperCol={{ span: 16 }}
          initialValues={{ remember: true }}
          autoComplete="off"
          style={STYLE.container.bgContent.form}
        >
          <Form.Item wrapperCol={{ offset: 4, span: 16 }} style={STYLE.container.bgContent.form.item}>
            <Input size="middle"
              style={STYLE.container.bgContent.form.item.input}
              prefix={<UserOutlined className="site-form-item-icon" style={STYLE.container.bgContent.form.item.input.icon} />}
              placeholder="用户名" value={username} onChange={e => { setUsername(e.target.value) }}></Input>
          </Form.Item>
          <Form.Item wrapperCol={{ offset: 4, span: 16 }} style={STYLE.container.bgContent.form.item}>
            <Input.Password size="middle"
              style={STYLE.container.bgContent.form.item.input}
              prefix={<LockOutlined className="site-form-item-icon" style={STYLE.container.bgContent.form.item.input.icon} />}
              placeholder="密码" value={password} onChange={e => { setPassword(e.target.value) }}></Input.Password>
          </Form.Item>
          <Form.Item wrapperCol={{ offset: 4, span: 16 }}>
            <Button onClick={() => handleClick('/')} block style={STYLE.container.bgContent.form.item.button}>登录</Button>
          </Form.Item>
        </Form>
      </div>
    </div>
  )
}