import React, { useState } from 'react';
import { connect } from 'react-redux';
import * as actionTypes from '@/store/action-types';
import { Avatar, Menu, Dropdown, Space, Modal, message } from 'antd'
import { useNavigate } from 'react-router-dom'
import { SlackOutlined } from '@ant-design/icons';
import 'antd/dist/antd.css';
import ModalPassword from './ModalPassword';
import { API_updatePassword } from '@/api';

function Info(props) {
    const navigate = useNavigate();

    const logout = () => {
        sessionStorage.setItem("login", false);
        navigate("/login");
        sessionStorage.clear();
    }

    const [isModalVisible, setIsModalVisible] = useState(false);

    const menu1 = (
        <Menu
            items={[
                {
                    key: '1',
                    label: (
                        <a target="_blank" rel="noopener noreferrer" onClick={() => showModal()}>
                            修改密码
                        </a>
                    ),
                },
                {
                    key: '2',
                    label: (
                        <a target="_blank" rel="noopener noreferrer" onClick={() => logout()}>
                            注销
                        </a>
                    ),
                }
            ]}
        />
    );

    const menu2 = [];

    const chooseMenu = (e) => {

    }

    const changePasswordModal = (data) => {
        data.oldPassword = btoa(data.oldPassword);
        data.newPassword = btoa(data.newPassword);
        API_updatePassword(data).then(res => {
            if (res == 1) {
                setIsModalVisible(false);
                message.success('密码修改成功，请重新登录！');
                logout();
            }
        })
    }

    const showModal = () => {
        setIsModalVisible(true);
    };

    const handleOk = () => {
        setIsModalVisible(false);
    };

    const handleCancel = () => {
        setIsModalVisible(false);
    };


    return (
        <div style={{ height: "80px", lineHeight: "80px", display: "-webkit-box" }}>
            <Menu items={menu2} mode="horizontal" onClick={chooseMenu} style={{ marginRight: "50px", lineHeight: "80px", color: "white", background: "none", borderBottom: "none" }}></Menu>
            <Avatar style={{ marginRight: "20px", backgroundColor: '#ff3131ab' }} icon={<SlackOutlined />} />
            <Modal width={500} title="修改密码" visible={isModalVisible} footer={false} destroyOnClose={true} onCancel={handleCancel}>
                <ModalPassword
                    showModal={handleCancel}
                    changePasswordModal={changePasswordModal}
                    username={sessionStorage.getItem('username')}
                    password={sessionStorage.getItem('password')}
                >
                </ModalPassword>
            </Modal>
            <Dropdown overlay={menu1} arrow>
                <a onClick={(e) => e.preventDefault()} style={{ marginRight: "20px" }}>
                    <Space style={{ color: "white" }}>
                        {sessionStorage.getItem('username')}
                    </Space>
                </a>
            </Dropdown>
        </div>
    )
}

//把state映射到props中去，意思就是把Redux中的数据映射到React中的props中去
//React想把Redux中的哪些数据拿过来用。
const mapStateToProps = (state, ownProps) => {
    return {
        name: state.formData.name,
        path: state.formData.imgpath
    }
}

//把action映射到props中去,这样使用props中方法触发action
const mapDispatchToProps = (dispatch, ownProps) => {
    return {
        saveFormData: (type, value) => dispatch({ type: actionTypes.SAVEFORMDATA, value: value, datatype: type }),
        saveImg: (path) => dispatch({ type: actionTypes.SAVEIMG, path: path })
    }
}
export default connect(mapStateToProps, mapDispatchToProps)(Info)

