import React from "react";
import { Button, Input, Form } from 'antd';


export default (props) => {
    const [form] = Form.useForm();

    const layout = {
        labelCol: {
            span: 8,
        },
        wrapperCol: {
            span: 12,
        },
    };
    const tailLayout = {
        wrapperCol: {
            offset: 10,
            span: 14,
        },
    };

    form.setFields([
        {
            name: ['username'],
            value: props.username
        },
        {
            name: ['oldPassword'],
            value: props.password
        }
    ])

    const cancelClick = () => {
        props.showModal();
    }

    const saveClick = () => {
        const formData = form.getFieldsValue();
        props.changePasswordModal(formData);
    }

    return (
        <div>
            <Form form={form}>
                <Form.Item
                    name={['username']}
                    label="用户名"
                    rules={[
                        {
                            required: true,
                        },
                    ]}
                    {...layout}
                >
                    <Input disabled />
                </Form.Item>
                <Form.Item
                    name={['oldPassword']}
                    label="旧密码"
                    rules={[
                        {
                            required: true,
                        },
                    ]}
                    {...layout}
                >
                    <Input disabled />
                </Form.Item>
                <Form.Item
                    name={['newPassword']}
                    label="新密码"
                    rules={[
                        {
                            required: true,
                        },
                    ]}
                    {...layout}
                >
                    <Input />
                </Form.Item>
                <Form.Item {...tailLayout}>
                    <Button onClick={cancelClick} >取消</Button>
                    <Button type="primary" onClick={saveClick} style={{ marginLeft: 20 }}>确定</Button>
                </Form.Item>
            </Form>
        </div>
    )
}