const path = require('path')
const HtmlWebpackPlugin = require('html-webpack-plugin')
const { CleanWebpackPlugin } = require('clean-webpack-plugin')
const CopyWebpackPlugin = require('copy-webpack-plugin');
const Webpack = require('webpack');

module.exports = {
    mode: 'development', // 开发模式
    // mode: 'production',
    entry: path.resolve(__dirname, './src/index.js'), // 项目入口文件
    output: {
        filename: '[name].[contenthash:8].js',
        path: path.resolve(__dirname, './dist') // 打包后的目录
    },
    resolve: {
        extensions: ['.ts', '.js'],//模块主文件包含index.ts
        alias: {
            "public": path.resolve(__dirname, './public'),
            '@': path.resolve('src')
        },
    },
    plugins: [
        new HtmlWebpackPlugin({
            template: path.resolve(__dirname, './index.html'),
            inject: true,
            favicon: path.join('public/img/favicon.ico')
        }),
        new CleanWebpackPlugin(),
        new CopyWebpackPlugin({
            patterns: [
                { from: path.resolve(__dirname, './public'), to: 'public' },
                // { from: path.join(cesiumSource, "Assets"), to: 'Assets' },
            ]
        }),
        new Webpack.DefinePlugin({
            CESIUM_BASE_URL: JSON.stringify('./')
        })
    ],
    devtool: 'eval',
    // devtool:'inline-source-map',
    module: {
        // 配置模块的读取和解析规则，通常用来配置 Loader。其类型是一个数组，数组里每一项都描述了如何去处理部分文件
        rules: [
            {
                test: /\.(js|jsx)$/,
                use: [{
                    loader: 'babel-loader'
                }]
            },
            // css样式解析
            {
                test: /\.css$/,
                // 处理顺序为从后到前，即先交给 css-loader 最后再给 style-loader。
                use: ['style-loader', 'css-loader']

            },
            // 图片解析
            {
                test: /\.(eot|svg|ttf|woff|woff2|jpg|png|jpeg)$/,
                use: [{
                    loader: "file-loader",
                    options: {
                        esModule: false
                    }
                }]
            },
            {
                test: /\.ts?$/,
                use: 'ts-loader',
                exclude: /node_modules/
            }
        ]
    },
    devServer: {
        port: 8086,
        hot: true,
        static: './',
        //后台代理
        proxy: {
            '/api/': {
                target: 'http://192.168.168.135:10010',
                // target: 'http://localhost:10010',
                ws: true,
                secure: false,
                changeOrigin: true,
                pathRewrite: {
                    '^/api/': '/'
                }
            }
        }
    }
}