// 用于处理动态菜单数据，将其转为 route 形式
export const addRoutes = (menulist = [], routes = []) => {
    let temp = [];
    let route = [];
    for (let i = 0; i < menulist.length; i++) {
        if (menulist[i].children && menulist[i].children.length > 0) {
            route = getRoute(menulist[i]);
            route.children = addRoutes(menulist[i].children);
            routes.push(route);
        } else {
            temp.push(getRoute(menulist[i]));
        }
    }
    // 返回路由结果
    return routes.concat(temp)
}

// 路由懒加载
const loadView = (path) => {
    return () => import(`../view${path}.vue`);
}



// 返回路由的基本格式
const getRoute = item => {
    // const modules =
    //     import.meta.glob('../views/**/*.vue')
    let route = {
        path: item.path,
        name: item.label,
        component: loadView(item.path) ,
        // 路由的子路由
        children: []

    };
    // 返回 route
    return route

}