import {
    createRouter,
    createWebHashHistory
} from "vue-router";
import nProgress from 'nprogress'
import 'nprogress/nprogress.css'
import {
    useStore
} from '../store/index';
nProgress.configure({
    showSpinner: false
})
const router = createRouter({
    // 内部提供了 history 模式的实现
    // createWebHistory路由模式路径不带#号(生产环境下不能直接访问项目，需要nginx转发)
    // createWebHashHistory路由模式路径带#号
    history: createWebHashHistory(),
    routes: [{
        path: "/login",
        name: "login",
        component: () => import("../views/login/login.vue"),
    },
    {
        path: "/",
        name: "homepage",
        component: () => import("../views/homePage/homepage.vue"),
        meta: {
            keepAlive: false
        }
    },
    ],
});
// 全局前置守卫
router.beforeEach(async (to, from, next) => {
    nProgress.start()
    const usestor = useStore();
    const hasToken = usestor.token;
    // 1.路由跳转前先判断是否有token
    if (hasToken) {
        // 1.1登录成功，跳转到首页
        if (to.path === '/login') {
            next();
            nProgress.done();
        } else {
            // 1.2登录成功，去其他页面----要判断是否有用户信息
            const hasUserInfo = usestor.userInfo.username;
            //有用户信息
            if (hasUserInfo) {
                // 1.2.1如果没有从已有的所有路由中匹配到路由，有从上个路由过来的就直接跳到上个路由，否则就跳到登录页
                if (to.matched.length === 0) {
                    // next({name: ''})----通过名称导航到特定路由。name: 是我要导航到的路由名称
                    from.name ? next({
                        name: from.name
                    }) : next('/login');
                } else {
                    next();
                }
            } else {
                // 1.2.2 登录成功但 没有用户信息----先通过store获取用户信息,根据用户来获取并添加动态路由
                next();

            }
        }
    } else {
        //2.没有token的话可以访问白名单页面（登录页面）
        if (to.name == 'login') {
            next()
        } else {
            next('/login');
        }
        // console.log(1);

        nProgress.done();
    }
})


// 全局后置钩子
router.afterEach(() => {
    nProgress.done(true)
})


export default router;