import {
  defineStore
} from 'pinia'
import {
  login
} from '@/api/user';
import {
  message
} from 'ant-design-vue';
import router from '@/router/index';
import {
  getAllRoom
} from '@/api/room.js'
import {
  // getAllCountry,
  // getAllVisa,
  // getAllGender,
  // getAllForeignGuest,
  // getAllInternalGuest,
  // getAllPlateNumber,
  // getAllReasonEntry,
  // getAllProvinciaUrbanAreas,
  // getAllNation,
  // getAllRoomType,
  getAllCode
} from '@/api/default';
export const useStore = defineStore('user', () => {
  const userInfo = ref();
  const token = ref(null);
  const hotelInfo = ref({
    hotelId: null,
    hotelAddress: null
  });
  const menuParams = ref({
    selectedKeys: ['/inland/inlandAdd'],
    openKeys: ['lkgl', '/inland/inlandAdd'],
    preOpenKeys: ['lkgl'],
    activeKey: '/inland/inlandAdd',
    panes: [{ title: '内宾入住', key: '/inland/inlandAdd', closable: false }]
  });
  // const hotelId = ref(null);
  const roomAll = ref([]);
  // const defaultType = ref({
  //   countryAll: [],
  //   visaAll: [],
  //   genderAll: [],
  //   foreignGuestAll: [],
  //   internalGuestAll: [],
  //   plateNumberAll: [],
  //   reasonEntryAll: [],
  //   provinciaUrbanAreasAll: [],
  //   nationAll: [],
  //   roomAllType: [],
  //   checkInStatusAll: [],
  //   departmentAll: []
  // });

  const defaultType = ref([]);

  const getUserInfo = async (param) => {
    login(param).then(res => {
      if (res.code == '9000') {
        message.success('登录成功!');
        hotelInfo.value.hotelId = param.hotelId;
        hotelInfo.value.hotelAddress = param.address;
        token.value = res.data;
        let strings = res.data.split("."); //截取token，获取载体
        userInfo.value = JSON.parse(decodeURIComponent(escape(window.atob(strings[1].replace(/-/g, "+").replace(/_/g, "/")))));
        router.push({
          name: 'homepage'
        });
        getAllCode().then(res => {
          defaultType.value = res.data;
          // for (let i = 0; i < res.data.length; i++) {
          //   switch (res.data[i].key) {
          //     case 1: //查询房间类型
          //       defaultType.value.roomAllType = res.data[i];
          //       break;
          //     case 2: //查询入住状态
          //       defaultType.value.checkInStatusAll = res.data[i];
          //       break;
          //     case 3: //查询所有内宾证件种类
          //       defaultType.value.internalGuestAll = res.data[i];
          //       break;
          //     case 4: //查询所有外宾证件种类
          //       defaultType.value.foreignGuestAll = res.data[i];
          //       break;
          //     case 5: //查询性别
          //       defaultType.value.genderAll = res.data[i];
          //       break;
          //     case 6: //查询所有车牌类型
          //       defaultType.value.plateNumberAll = res.data[i];
          //       break;
          //     case 7: //查询入境事由
          //       defaultType.value.reasonEntryAll = res.data[i];
          //       break;
          //     case 8: //查询所有签证种类
          //       defaultType.value.visaAll = res.data[i];
          //       break;
          //     case 9: //查询所有国家
          //       defaultType.value.countryAll = res.data[i];
          //       break;
          //     case 10: //查询所有民族
          //       defaultType.value.visaAll = res.data[i];
          //       break;
          //     case 11: //查询全国省市县
          //       defaultType.value.departmentAll = res.data[i];
          //       break;
          //   }
          // }
        })
        //当前酒店下所有的房间号
        getAllRoom({
          hotelid: param.hotelId
        }).then(res => {
          roomAll.value = res.data;
        });



        // //查询所有国家
        // getAllCountry().then(res => {
        //   defaultType.value.countryAll = res.data;
        // });

        // //查询所有签证种类
        // getAllVisa().then(res => {
        //   defaultType.value.visaAll = res.data;
        // })

        // //查询性别
        // getAllGender().then(res => {
        //   defaultType.value.genderAll = res.data;
        // })

        // //查询所有外宾证件种类
        // getAllForeignGuest().then(res => {
        //   defaultType.value.foreignGuestAll = res.data;
        // })

        // //查询所有内宾证件种类
        // getAllInternalGuest().then(res => {
        //   defaultType.value.internalGuestAll = res.data;
        // })

        // //查询所有车牌类型
        // getAllPlateNumber().then(res => {
        //   defaultType.value.plateNumberAll = res.data;
        // });

        // //查询入境事由
        // getAllReasonEntry().then(res => {
        //   defaultType.value.reasonEntryAll = res.data;
        // })

        // //查询省市县
        // getAllProvinciaUrbanAreas().then(res => {
        //   defaultType.value.provinciaUrbanAreasAll = res.data;
        // })

        // //查询所有民族
        // getAllNation().then(res => {
        //   defaultType.value.nationAll = res.data;
        // })

        // //查询所有房间类型
        // getAllRoomType().then(res => {
        //   defaultType.value.roomAllType = res.data;
        // })

      }
    }).catch(err => {
      message.error(err.message);
    })
  }
  const clearUserInfo = () => {
    userInfo.value = {};
    localStorage.removeItem('user');
  };

  const returnCode = key => {
    if (defaultType.value.length > 0) {
      let mateCode = defaultType.value.filter(item => {
        return item.key == key
      });
      return mateCode[0].value
    } else {
      getCode();
    }
  }

  const getCode = () => {
    getAllCode().then(res => {
      defaultType.value = res.data;
      let mateCode = defaultType.value.filter(item => {
        return item.key == key
      });
      return mateCode[0].value
    })
  }
  const clearAll = () => {
    defaultType.value = [];
    roomAll.value = [];
  }
  const setAll = (dataCode,dataRoom) => {
    defaultType.value = dataCode;
    roomAll.value = dataRoom
  }
  return {
    userInfo,
    token,
    hotelInfo,
    menuParams,
    // hotelId,
    roomAll,
    defaultType,
    returnCode,
    getUserInfo,
    clearUserInfo,
    clearAll,
    setAll,
  }
}, {
  persist: true
})