import {
    websocketStore
} from "@/store/websocketStore.js";
const myWebsocketStore = websocketStore();
class initWebsocket {
    constructor() {
        this.obj = {
            certificatecardid: '',
            msg: '',
            cardinfo: '',
            cardName: '',
            str: '',
            devicetype: '',
            statusbar: '',
            certificatePhoto: ''
        };
        this.websocket = null;
    }

    connect() {
        try {
            var readyState = new Array("on connection", "Connection established",
                "Closing connection", "Close connection");
            var host = "ws://127.0.0.1:90/echo/";
            this.websocket = new WebSocket(host);
            this.websocket.onopen = () => {
                this.obj.statusbar = readyState[this.websocket.readyState];
                this.websocket.send(18601);
                this.websocket.send(18402);


            }
            this.websocket.onmessage = (event) => {
                var str = event.data;
                var strsub = str;
                //此处要加多种扫描仪
                var deviceArr = new Array();
                deviceArr[0] = "D300+";
                deviceArr[1] = "D800II";
                deviceArr[2] = "D120+";
                deviceArr[3] = "L1250+";
                deviceArr[4] = "L1250";
                deviceArr[5] = "B660";
                deviceArr[6] = "M110";
                deviceArr[7] = "E2000";
                deviceArr[8] = "CR620+";
                deviceArr[9] = "DSL3100";
                deviceArr[10] = "AVA5";
                deviceArr[11] = "B6680";
                deviceArr[12] = "AW570";
                deviceArr[13] = "M1260";
                deviceArr[14] = "DSL62";
                deviceArr[15] = "U350II";
                deviceArr[16] = "L7280+";
                deviceArr[17] = "AVA5+";
                deviceArr[18] = "D800II+";
                deviceArr[19] = "AVA5 Plus";
                if (this.IsInArray(deviceArr, str)) {
                    //此处可更换为自己使用的扫描仪型号
                    this.obj.devicetype = "scanner";
                    return;
                }
                if (strsub != "") {
                    str = strsub.replace(/\*/g, "\r\n");
                    this.obj.str = str; //传入textarea中
                    //console.log('Message state', websocket.readyState);
                }

                this.tup() //对返回信息进行处理，显示到页面

            }
            this.websocket.onclose = () => {
                this.obj.statusbar = readyState[this.websocket.readyState];
            }
            setInterval(() => {
                this.AutoPhotoAndRecog()
            }, 1000);

        } catch (exception) {
            this.obj.statusbar = "Error";
        }
    }
    //判断字符串是否在数组中方法
    IsInArray(arr, val) {
        let testStr = ',' + arr.join(",") + ",";
        return testStr.indexOf("," + val + ",") != -1;
    }

    send() {
        try {
            this.websocket.send("181026150"); //发送护照芯片内容读取设置指令，固定指令，请勿变动
            this.websocket.send("1810331"); //设置保存图片类型，18103+31 表示所有图片都保存
            this.websocket.send("181041"); //是否识别识读区，请勿变动
            this.websocket.send("181061"); //是否返回base64格式图片
            this.websocket.send("1810731"); //哪些图片返回base64,默认所有图片都返回

        } catch (exception) {
            this.obj.msg = "Error sending data";
        }
    }

    AutoPhotoAndRecog() {
        var str = this.obj.devicetype;
        if (str = "scanner") {
            setInterval(() => {
                this.getInformation()
            }, 2000);
        } else {
            this.getInformation();
        }
    }

    getInformation() {
        if (this.websocket != null) {
            this.websocket.send("11112");
        }
    }




    tup() {
        var str = this.obj.str;
        //字符分割   	
        var seek = str.split("data:image/jpeg;base64,");
        var len = seek.length; //没有找到报头 此时会返回原串，长度也为1
        if (len > 1) //有证件信息和图像，当只有一张图片的时候，有一个base64的头，会分割成两段，第一段为空，第二段会去掉头的图像base64串
        {
            var seek0 = seek[0]; //身份信息数据
            //alert(seek0);
            var strhead = "";
            var strChipHead = "";
            for (var i = 1; i < len; i++) //头像数据//头像数据 data:image/jpeg;base64,xx....  xx 表示图片的类型  01 为白光，以此类推
            {
                if (seek[i].length > 2) {
                    var strType = seek[i][0] + seek[i][1];
                    seek[i] = seek[i].substr(2);
                    if (strType == "01") //白光
                    {
                        seek[i] = "data:image/jpeg;base64," + seek[i];
                    } else if (strType == "02") //红外
                    {
                        seek[i] = "data:image/jpeg;base64," + seek[i];
                    } else if (strType == "04") //紫外
                    {
                        seek[i] = "data:image/jpeg;base64," + seek[i];
                    } else if (strType == "08") //版面头像
                    {
                        strhead = seek[i];
                        seek[i] = "data:image/jpeg;base64," + seek[i];

                    } else if (strType == "16") //芯片头像
                    {
                        strChipHead = seek[i];
                        seek[i] = "data:image/jpeg;base64," + seek[i];

                    }
                }

            }
            //优先显示芯片头像
            let seek1 = null;
            if (strChipHead != "") {
                seek1 = "data:image/jpeg;base64," + strChipHead;
                this.obj.certificatePhoto = seek1;
            } else {
                seek1 = "data:image/jpeg;base64," + strhead;
            }
            if (seek0 != "") {
                seek0 = seek0.replace(/\*/g, "\r\n");
                this.obj.msg = "Receive information:" + seek0;
                this.getcardInfo();
            }

        } else {
            //var strsub = str.substr(1);
            if (str != "") {
                str = str.replace(/\*/g, "\r\n");
                this.obj.msg = "Receive information:" + str;
                //getcardInfo();
            }
        }

    }

    singlerecog() {
        var str = this.obj.msg;
        if (str == "scanner") {
            this.websocket.send("1000" + this.obj.certificateType + "02");
        }
        this.websocket.send("18201" + this.obj.certificateType);
    }

    getcardInfo() {
        var str = this.obj.msg;
        var cardid = str.substring(str.indexOf(":") + 1, str.indexOf("\r\n")); //获取返回信息中的证件类型编号IDCardID
        if (cardid == "二代证读卡") {
            this.obj.cardinfo = "二代证读芯片";
            myWebsocketStore.identityInformation = {};
            myWebsocketStore.identityInformation = this.obj;
            return;
        }
        var card1by1;
        var cardname;
        for (var i = 0; i < 80; i++) {
            if (this.obj.certificateType) {
                card1by1 = this.obj.certificatecardid;
            }
            if (card1by1 == cardid) {
                cardname = this.obj.cardName;
                break;
            }
            this.obj.msg = "证件类型:" + cardid + "\n" + "证件名称:" + cardname;
            myWebsocketStore.identityInformation = this.obj;
            return this.obj;

        }
    }



    close() {
        // 关闭连接
        this.websocket.close()
        // 销毁 websocket 实例对象
        this.websocket = null;
    }
}
export default initWebsocket;