import request from "@/utils/request";
/**
 * @param data请求接口传递的参数
 * @return {Promise}
 */

//获取验证码
export const getVerifyCode = (params) => {
    return request({
        url: "/rest/system/user/verifyCode",
        method: "GET",
        params,
        responseType: 'arraybuffer'
    });
};

//查询用户列表
export const getUserList = (data) => {
    return request({
        url: '/rest/system/user/queryList',
        method: "POST",
        data
    })
}

//用户登录
export const login = (data) => {
    return request({
        url: '/rest/system/user/login',
        method: 'POST',
        data
    })
}


//用户注册
export const register = (data) => {
    return request({
        url: '/rest/system/user/add',
        method: 'POST',
        data
    });
}

//修改用户密码
export const editPassword = params => {
    return request({
        url: "/rest/system/user/updatePassword",
        method: 'GET',
        params
    })
}

//重置密码
export const resetPassword = params => {
    return request({
        url: "/rest/system/user/resetPassword",
        method: 'GET',
        params
    })
}


//图片上传
export const upLoadImg = (data) => {
    return request({
        url: "/rest/file/uploadPhoto",
        method: 'POST',
        data
    })
}


//用户新增
export const addPersonnel = (data) => {
    return request({
        url: "/rest/system/user/add",
        method: 'POST',
        data
    })
}

//用户更新
export const updatePersonnel = (data) => {
    return request({
        url: "/rest/system/user/updateInfo",
        method: 'POST',
        data
    })
}

//删除用户
export const removePersonnel = (params) => {
    return request({
        url: "/rest/system/user/remove",
        method: 'GET',
        params
    })
}