import request from "@/utils/request";
/**
 * @param data请求接口传递的参数
 * @return {Promise}
 */

//获取所有房间号
export const getAllRoom = params => {
  return request({
    url: '/rest/hotel/room/queryList',
    method: 'GET',
    params
  });
}

//新增房间号
export const addRooms = data => {
  return request({
    url: '/rest/hotel/room/batchAddRoom',
    method: 'POST',
    data
  });
}

//预览新增房间号
export const previewRooms = data => {
  return request({
    url: '/rest/hotel/room/createRooms',
    method: 'POST',
    data
  });
}

//分页查询房间
export const getRooms  = data=>{
  return request({
    url:'/rest/hotel/room/queryListByParams',
    method:'POST',
    data
  })
}

//编辑房间
export const updateRoomsInfo  = data=>{
  return request({
    url:'/rest/hotel/room/updateInfo',
    method:'POST',
    data
  })
}

//删除房间
export const bulkRemoveRooms  = data=>{
  return request({
    url:'/rest/hotel/room/bulkRemove',
    method:'POST',
    data
  })
}

//查询房间状态 上部分
export const queryRoomStatus  = params=>{
  return request({
    url:'/rest/hotel/hotelManger/statistics',
    method:'POST',
    params
  })
}

//查询房间状态 下部分
export const queryStatisticsRoomStatus  = params=>{
  return request({
    url:'/rest/hotel/hotelManger/statisticsRoomStatus',
    method:'POST',
    params
  })
}