import request from "@/utils/request";

/**
 * @param data请求接口传递的参数
 * @return {Promise}
 */




//权限查询
export const queryRole = () => {
  return request({
    url: '/rest/system/role/queryList',
    method: 'GET'
  })
}


//权限菜单提交
export const grantMenuRole = (data,roleId) => {
  return request({
    url: '/rest/system/role/grantMenu/'+roleId,
    method: 'POST',
    data
  })
}

//角色新增
export const addRoles = (data) => {
  return request({
    url: '/rest/system/role/add',
    method: 'POST',
    data
  })
}


//角色编辑
export const updateRoles = (data) => {
  return request({
    url: '/rest/system/role/updateInfo',
    method: 'POST',
    data
  })
}

//角色删除
export const bulkRemoveRoles = (data) => {
  return request({
    url: '/rest/system/role/bulkRemove',
    method: 'POST',
    data
  })
}
