import request from "@/utils/request";
/**
 * @param data请求接口传递的参数
 * @return {Promise}
 */

//根据派出所编号查找旅馆
export const queryHotelByDept = (params) => {
    return request({
      url: '/rest/hotel/hotel/queryList',
      method: 'GET',
      params
    });
  }
//根据旅馆编号查找旅馆信息
export const queryHotel = (params) => {
  return request({
    url: '/rest/hotel/hotel/queryHotelInfo',
    method: 'POST',
    params
  });
}
//修改旅馆基本信息
export const updateHotel = (data) => {
  return request({
    url: '/rest/hotel/hotel/updateInfo',
    method: 'POST',
    data
  });
}
//多图片上传
export const upLoadArrayImage = (data) => {
  return request({
      url: "/rest/hotel/hotel/uploadImage",
      method: 'POST',
      data
  })
}
//删除旅馆单图片上传的图片
export const removeArrayImage = (data) => {
  return request({
      url: "/rest/file/batchRemove",
      method: 'POST',
      data
  })
}
