import { defineConfig} from 'vite'
import vue from '@vitejs/plugin-vue'
import { resolve} from "path";
import AutoImport from 'unplugin-auto-import/vite';
//自动导入ui-组件 比如说ant-design-vue  element-plus等
import Components from "unplugin-vue-components/vite";
//ant-design-vue
import {  AntDesignVueResolver} from "unplugin-vue-components/resolvers";

// https://vitejs.dev/config/
export default defineConfig({
  plugins: [
    vue(),
    AutoImport({
      // 自动导入 Vue 相关函数，如：ref, reactive, toRef 等
      imports: ['vue', 'vue-router'],
    }),
    Components({
      //ant-design-vue   importStyle = false 样式就没了
      resolvers: [
        AntDesignVueResolver({
          importStyle: "less",
          resolveIcons: true
        }),
      ],
    })
  ],
  //别名src下的资源路径都可以以@/替换
  resolve: {
    alias: [{
      find: "@",
      replacement: resolve(__dirname, "src"),
    }, ],
  },
  css: {
    preprocessorOptions: {
      less: {
        javascriptEnabled: true
      }
    }
  },
  //服务器
  server: {
    host: "0.0.0.0", //本地打开 地址栏为 http://localhost:3366/
    port: 3366, //指定端口号
    open: true, //项目启动成功自动打开浏览器
    proxy: {
      //拦截请求地址包含/api，匹配到的是生产环境
      "/api": {
        target: "http://172.16.60.201:8081", //后台服务地址
        changeOrigin: true,
        //重写，/api开头的替换成空字符串，即去掉接口中去掉这个字符串
        rewrite: (path) => path.replace(/^\/api/, "")
      },
      //匹配到的时开发环境
      "/dev": {
        target: "http://localhost:5000", //后台服务地址
        changeOrigin: true,
        //重写，/api开头的替换成空字符串，即去掉接口中去掉这个字符串
        rewrite: (path) => path.replace(/^\/dev/, ""),
      },
    }
  },

})