import request from "@/utils/request";
/**
 * @param data请求接口传递的参数
 * @return {Promise}
 */

//新增外宾
export const addForeignGuestCheckIn = (data) => {
    return request({
        url: '/rest/hotel/foreignGuestCheckIn/add',
        method: 'POST',
        data
    });
}

//查询外宾
export const getForeignGuestCheckInList = (data) => {
    return request({
        url: '/rest/hotel/foreignGuestCheckIn/queryListByParams',
        method: 'POST',
        data
    });
}

//外宾离店
export const departureForeignGuestCheckIn = (data) => {
    return request({
        url: '/rest/hotel/foreignGuestCheckIn/departure',
        method: 'POST',
        data
    });
}

//更新外宾
export const updateForeignGuestCheckInList = (data) => {
    return request({
        url: '/rest/hotel/foreignGuestCheckIn/updateInfo',
        method: 'POST',
        data
    });
}


//查询外宾详情
export const queryForeignGuestDetail = (params) => {
    return request({
        url: '/rest/hotel/foreignGuestCheckIn/queryForeignGuestDetail',
        method: 'GET',
        params
    });
}