import request from "@/utils/request";
/**
 * @param data请求接口传递的参数
 * @return {Promise}
 */

/**内宾分页查询 */
export const inlandQuery = (data) => {
    return request({
        url: '/rest/hotel/domesticGuestCheckIn/queryListByParams',
        method: 'POST',
        data
    });
}
/**内宾单个查询 */
export const inlandQueryOne = (params) => {
    return request({
        url: '/rest/hotel/domesticGuestCheckIn/queryDomesticGuestDetail',
        method: 'GET',
        params
    });
}
/**内宾登记 */
export const inlandAdd = (data) => {
    return request({
        url: '/rest/hotel/domesticGuestCheckIn/add',
        method: 'POST',
        data
    });
}
/**内宾更新 */
export const inlandEdit = (data) => {
    return request({
        url: '/rest/hotel/domesticGuestCheckIn/updateInfo',
        method: 'POST',
        data
    });
}
/**内宾删除 */
export const inlandDelete = (data) => {
    return request({
        url: '/rest/hotel/domesticGuestCheckIn/bulkRemove',
        method: 'POST',
        data
    });
}
/**内宾离店 */
export const inlandCheckOut = (data) => {
    return request({
        url: '/rest/hotel/domesticGuestCheckIn/departure',
        method: 'POST',
        data
    });
}
// /**内宾个人信息查询 */
// export const inlandOneQuery = params => {
//     return request({
//         url: '/rest/hotel/domesticGuestCheckIn/departure',
//         method: 'GET',
//         params
//     });
// }
/**字典查询 */
export const inlandGender = params => {
    return request({
        url: '/agile/rest/index/api/default/queryGenderType',
        method: 'GET',
        params
    });
}
