import request from "@/utils/request";
/**
 * @param data请求接口传递的参数
 * @return {Promise}
 */

//获取所有国家
export const getAllCountry = () => {
    return request({
        url: '/agile/rest/index/api/default/queryNationalityType',
        method: 'GET'
    });
}


//获取签证类型
export const getAllVisa = () => {
    return request({
        url: '/agile/rest/index/api/default/queryVisaType',
        method: 'GET'
    });
}

//获取性别
export const getAllGender = () => {
    return request({
        url: '/agile/rest/index/api/default/queryGenderType',
        method: 'GET'
    });
}

//获取外宾证件种类
export const getAllForeignGuest = () => {
    return request({
        url: '/agile/rest/index/api/default/queryForeignGuestType',
        method: 'GET'
    });
}

//获取内宾证件种类
export const getAllInternalGuest = () => {
    return request({
        url: '/agile/rest/index/api/default/queryInternalGuestType',
        method: 'GET'
    });
}

//获取车牌类型
export const getAllPlateNumber = () => {
    return request({
        url: '/agile/rest/index/api/default/queryPlateNumberType',
        method: 'GET'
    });
}

//入境事由
export const getAllReasonEntry = () => {
    return request({
        url: '/agile/rest/index/api/default/queryReasonEntryType',
        method: 'GET'
    });
}

//查询省市县
export const getAllProvinciaUrbanAreas = () => {
    return request({
        url: '/agile/rest/index/api/default/queryProvincialUrbanAreas',
        method: 'GET'
    });
}

//查询民族
export const getAllNation = () => {
    return request({
        url: '/agile/rest/index/api/default/queryNationType',
        method: 'GET'
    });
}

//查询房间类型
export const getAllRoomType = () => {
    return request({
        url: '/agile/rest/index/api/default/queryRoomType',
        method: 'GET'
    });
}

//查询所有字典
export const getAllCode = () => {
    return request({
        url: '/rest/hotel/code/queryList',
        method: 'GET'
    });
}

//图片上传
export const uploadImg = (data) => {
    return request({
        url: '/rest/file/upload?bucket=PHOTO',
        method: 'POST',
        data
    });
}

//查看图片路径
export const getImgByUrl = (params) => {
    return request({
        url: '/rest/file/pathPhoto',
        method: 'POST',
        params
    });
}