import { get_exame, post_exame, delete_util_exame, addParam } from "../../util/http_util";

const PREFIX = "api_exame/user/";
const PREFIX_ADMIN = "api_exame/admin/";


//查询考试记录
export const queryExame = (pageNum, pageSize, account, name) => {
    let url = `${PREFIX}questionBank/queryExame`;
    url += addParam({ pageNum, pageSize, account, name });
    return get_exame(url);
}

export const queryDetails = data => {
    return post_exame(`api_exame/admin/TRecordDetails/queryDetails`, data);
}

//新建记录
export const createRecord = data => {
    return post_exame(`${PREFIX_ADMIN}TExameRecord/createRecord`, data);
}

//查询记录
export const queryRecord = data => {
    return post_exame(`${PREFIX_ADMIN}TExameRecord/queryRecord`, data);
}

//创建考试题目
export const createExame = (name, suggestTime, startTime, endTime, singleNum, multiNum, judgeNum, singlePointValue, multiPointValue, judgePointValue) => {
    let url = `${PREFIX}questionBank/createExame`;
    url += addParam({ name, suggestTime, startTime, endTime, singleNum, multiNum, judgeNum, singlePointValue, multiPointValue, judgePointValue });
    return get_exame(url)
}

//删除试卷
export const removeExame = data => {
    return delete_util_exame(`${PREFIX}questionBank/removeExame`, data)
}


export const addQuestionBank = data => {
    return post_exame(`${PREFIX_ADMIN}questionBank/addQuestionBank`, data);
}

export const updateQuestionBankById = data => {
    return post_exame(`${PREFIX_ADMIN}questionBank/updateQuestionBankById`, data);
}

export const deleteQuestionBankById = data => {
    return post_exame(`${PREFIX_ADMIN}questionBank/deleteQuestionBankById`, data);
}

export const listQuestionBank = data => {
    return post_exame(`${PREFIX_ADMIN}questionBank/listQuestionBank`, data);
}

export const addTExameContent = data => {
    return post_exame(`${PREFIX_ADMIN}TExameContent/addTExameContent`, data);
}

export const updateTExameContent = data => {
    return post_exame(`${PREFIX_ADMIN}TExameContent/updateTExameContent`, data);
}

export const deleteTExameContent = data => {
    return post_exame(`${PREFIX_ADMIN}TExameContent/deleteTExameContent`, data);
}

export const listTExameContent = data => {
    return post_exame(`${PREFIX_ADMIN}TExameContent/listTExameContent`, data);
}
