import { get, post, delete_util, fileUpload_PUT, addParam } from "../../util/http_util";

const PREFIX_DOCUMENT = "api/rest/3z/document/";
const PREFIX_RESOURCE = "api/rest/3z/resource/";
const PREFIX_ELASTIC = "api/rest/elastic/";




// 板块查询
export const queryLiteratureFolder = (module) => {
    return get(`${PREFIX_DOCUMENT}queryLiteratureFolder?module=${module}`)
}

// 文献资料查询
export const queryLiterature = (module, pageNum, pageSize, origin_name, folder, stick) => {
    let url = `${PREFIX_DOCUMENT}queryLiterature`;
    url += addParam({ module, pageNum, pageSize, origin_name, folder, stick });
    return get(url);
}

//多板块文献资料查询
export const multiQueryLiterature = (module, showPic, ids) => {
    let url = `${PREFIX_DOCUMENT}multiQueryLiterature`;
    url += addParam({ module, showPic });
    return post(url, ids);
}

// 新增人员关联信息
export const addRelatedInfo = (data) => {
    return post(`${PREFIX_RESOURCE}addRelatedInfo`, data);
}

//文献增加标签
export const addLiteratureLabel = (id, data) => {
    return post(`${PREFIX_DOCUMENT}addLiteratureLabel?id=${id}`, data);
}

//查询收藏目录
export const queryCollectionFolder = (collector) => {
    return get(`${PREFIX_RESOURCE}queryCollectionFolder?collector=${collector}`);
}

//添加收藏
export const addCollection = (data) => {
    return post(`${PREFIX_RESOURCE}addCollection`, data);
}

//添加收藏夹目录
export const addCollectionFolder = data => {
    return post(`${PREFIX_RESOURCE}addCollectionFolder`, data);
}

//删除收藏目录
export const removeCollectionFolder = id => {
    return delete_util(`${PREFIX_RESOURCE}removeCollectionFolder?folderId=${id}`);
}

//文献资料上传
export const uploadLiterature = data => {
    return fileUpload_PUT(`${PREFIX_DOCUMENT}uploadLiterature`, data)
}

//文献资料删除
export const removeLiterature = (folder, name) => {
    return delete_util(`${PREFIX_DOCUMENT}removeLiterature?folder=${folder}&name=${name}`);
}

//给文献资料附加图片
export const addPictureToLiterature = data => {
    return fileUpload_PUT(`${PREFIX_DOCUMENT}addPictureToLiterature`, data);
}

//批量文献置顶
export const bulkStickLiterature = data => {
    return post(`${PREFIX_DOCUMENT}bulkStickLiterature`, data);
}

//文献资料批量删除
export const removeLiteratureByBatch = data => {
    return delete_util(`${PREFIX_DOCUMENT}removeLiteratureByBatch`, data);
}

//批量修改文献资料所在的板块
export const bulkChangeLiteratureFolder = data => {
    return post(`${PREFIX_DOCUMENT}bulkChangeLiteratureFolder`, data)
}

//板块名称修改
export const updateLiteratureFolder = data => {
    return post(`${PREFIX_DOCUMENT}updateLiteratureFolder`, data)
}

//查询相关推荐文献资料
export const queryRecommendLiterature = id => {
    return post(`${PREFIX_ELASTIC}queryRecommendLiterature?id=${id}`);
}

//分页检索文献列表
export const searchLiterature = (module, pageNum, pageSize, text) => {
    // let url = `${PREFIX_ELASTIC}queryRecommendLiterature`;
    // url += addParam({ module, pageNum, pageSize, text });
    let url = `${PREFIX_ELASTIC}searchLiterature`;
    url += addParam({ module, pageNum, pageSize });
    return post(url,text);
}

//根据文献name获取文献
export const queryLiteratureById = name => {
    return get(`${PREFIX_ELASTIC}queryLiteratureById?id=${name}`);
}

//文件文献预览
export const previewPdf = (bucket, objectName) => {
    window.open(`api/rest/file/pdf/${bucket}?objectName=${objectName}`);
}

//文件文献下载
export const downloadFile = (bucket, objectName) => {
    window.open(`api/rest/file/download/${bucket}/${objectName}`);
}

//文件文献下载
export const downloadDocument = (bucket, objectName,originFileName) => {
    window.open(`api/rest/file/download/${bucket}/${objectName}?originFileName=`+originFileName);
}