import { get, post, fileUpload, addParam } from "../../util/http_util";

const PREFIX_CHATROOM = 'api/rest/chat/chatroom';

//增加聊天室（群组）议题
export const addIssue = data => {
    return post(`${PREFIX_CHATROOM}/addIssue`, data);
}

//创建聊天室(群组)
export const createChatRoom = data => {
    return post(`${PREFIX_CHATROOM}/create`, data);
}

//查询某个聊天室（群组）详情信息
export const getChatRoomMemberInfo = (id) => {
    return get(`${PREFIX_CHATROOM}/memberInfo?id=${id}`);
}

//加入聊天室（群组）
export const joinChatRoom = (chatRoomId, userId) => {
    return get(`${PREFIX_CHATROOM}/join?chatRoomId=${chatRoomId}&userId=${userId}`);
}

//离开聊天室（群组）
export const leaveChatRoom = (userId) => {
    return get(`${PREFIX_CHATROOM}/leave?chatRoomId=${id}&userId=${userId}`);
}

//查询某个用户所有聊天室（群组）
export const getChatRoomList = (data) => {
    return post(`${PREFIX_CHATROOM}/list`, data);
}

//阅读（群组）信息
export const readChatRoom = (chatRoomId, userId) => {
    return get(`${PREFIX_CHATROOM}/readChatRoom?chatRoomId=${chatRoomId}&userId=${userId}`);
}

//设置聊天室（群组）当前议题
export const setChatRoomCurrentIssue = (chatRoomId, currentIssue) => {
    return get(`${PREFIX_CHATROOM}/setChatRoomCurrentIssue?chatRoomId=${chatRoomId}&currentIssue=${currentIssue}`);
}

//上传文件
export const upLoadFiles = (bucket, data) => {
    return fileUpload(`api/rest/file/upload?bucket=${bucket}`, data)
}

//启动聊天室（群组）
export const startExercise = (chatRoomId) => {
    return post(`${PREFIX_CHATROOM}/start?chatRoomId=${chatRoomId}`);
}

//删除聊天室（群组）
export const removeExercise = (chatRoomId) => {
    return get(`${PREFIX_CHATROOM}/remove?chatRoomId=${chatRoomId}`);
}

//停止聊天室（群组）
export const stopExercise = (data) => {
    return post(`${PREFIX_CHATROOM}/end`, data);
}

//配置聊天室（群组）
export const setMember = (data) => {
    return post(`${PREFIX_CHATROOM}/setMember`, data);
}




