import { get, post, delete_util } from "../util/http_util";

//#region 公共
/**
 * 添加param
 * @param {*} param 
 * @returns 
 */
function addParam(param) {
    let url = "";
    let keys = Object.getOwnPropertyNames(param);
    keys.forEach(function (key, index) {
        if (param[key] != undefined) {
            if (index == 0) {
                url += "?";
            }
            url += key + "=" + param[key];
            if (index != keys.length - 1) {
                url += "&";
            }
        }
    });
    return url;
}
//#endregion

/**
 * 查询用户文献上传信息列表
 * @param {*} pageNum 
 * @param {*} pageSize 
 * @param {*} body 
 * @returns 
 */
export function queryUserPerformance(pageNum = 1, pageSize = 10, logType = LITERATURE, body = {}) {
    return post(`api/rest/user/queryUserPerformance?pageNum=${pageNum}&pageSize=${pageSize}&logType=${logType}`, body);
}

/**
 * 统计用户文献上传数量
 * @param {*} pageNum 
 * @param {*} pageSize 
 * @param {*} body 
 * @returns 
 */
export function countUserPerformance(pageNum = 1, pageSize = 10, logType = LITERATURE, body = {}) {
    return post(`api/rest/user/countUserPerformance?pageNum=${pageNum}&pageSize=${pageSize}&logType=${logType}`, body);
}

/**
 * 查询消息
 * @param {*} account 
 * @param {*} pageNum
 * @param {*} pageSize 
 * @param {*} name 
 * @returns 
 */
export function queryNotification(pageNum, pageSize, account, text) {
    let url = `api/rest/user/queryNotification`;
    url += addParam({ pageNum, pageSize, account, text });
    return get(url);
}


/**
 * 删除消息消息
 * @param {*} ids 
 * @param {*} account
 * @returns 
 */
export function removeNotification(ids, account) {
    return delete_util(`api/rest/user/removeNotification?account=${account}`, ids);
}

/**
 * 
 * @param {*} account 
 * @param {*} noteId 
 * @returns 
 */
export function readNotification(account, noteId) {
    let url = `api/rest/user/readNotification`;
    url += addParam({ account, noteId });
    return post(url, {});
}

export function getUserList() {
    return get("api/rest/system/user/queryUser")
}