const path = require('path')
const Webpack = require('webpack')
const HtmlWebpackPlugin = require('html-webpack-plugin')
const { CleanWebpackPlugin } = require('clean-webpack-plugin')
const CopyWebpackPlugin = require('copy-webpack-plugin')
const vueLoaderPlugin = require('vue-loader/lib/plugin')

module.exports = {
    mode: 'development', // 开发模式
    // mode: 'production',
    entry: {
        main: path.resolve(__dirname, './src/main.js'),
        onlyoffice: path.resolve(__dirname, './src/onlyoffice.js')
    }, // 项目入口文件
    output: {
        filename: '[name].[contenthash:8].js',
        path: path.resolve(__dirname, './web') // 打包后的目录
    },
    resolve: {
        alias: {
            '@': path.join(__dirname, './src/')
        }
    },
    plugins: [
        new HtmlWebpackPlugin({
            template: path.resolve(__dirname, './index.html'),
            filename: 'index.html',
            inject: true,
            chunks: ['main'],
            favicon: path.join('static/img/favicon.ico')
        }),
        new HtmlWebpackPlugin({
            template: path.resolve(__dirname, './onlyoffice/dev.html'),
            filename: 'onlyoffice.html',
            inject: 'body',
            chunks: ['onlyoffice'],
            favicon: path.join('static/img/favicon.ico'),
            // tags: {//webpack5.5以上才支持
            //     body: [{
            //         tagName: 'script',
            //         attributes: {
            //             src: 'https://cdn.bootcdn.net/ajax/libs/jquery/3.6.0/jquery.min.js',
            //         },
            //     }]
            // }
        }),
        new CleanWebpackPlugin(),
        // new CopyWebpackPlugin({
        //     patterns: [
        //         { from: path.resolve(__dirname, './static'), to: 'static' },
        //         { from: path.resolve(__dirname, './onlyoffice.html'), to: 'onlyoffice.html' },
        //     ]
        // }),
        new vueLoaderPlugin()
    ],
    devtool: 'eval',
    // devtool:'inline-source-map',
    module: {
        // 配置模块的读取和解析规则，通常用来配置 Loader。其类型是一个数组，数组里每一项都描述了如何去处理部分文件
        rules: [
            // vue组件文件解析
            {
                test: /\.vue$/,
                use: ['vue-loader']
            },
            // js文件解析
            {
                test: /\.js$/,
                use: [{
                    loader: 'babel-loader',
                    options: {
                        plugins: ['syntax-dynamic-import']
                    }
                }]
            },
            // css样式解析
            {
                test: /\.css$/,
                // 处理顺序为从后到前，即先交给 css-loader 最后再给 style-loader。
                use: ['style-loader', 'css-loader']

            },
            // 图片解析
            {
                test: /\.(eot|svg|ttf|woff|woff2|jpg|png|jpeg)$/,
                use: [{
                    loader: "file-loader",
                    options: {
                        esModule: false
                    }
                }]
            },
            // 解析scss
            {
                test: /\.scss$/,
                // 注意:use 的别名 是 loaders。下面3个加载的执行顺序是 3 2 1
                use: [
                    // 1.不用传递参数可以简写
                    'style-loader',
                    {
                        loader: 'css-loader',
                    },
                    'sass-loader'
                ],
            }
        ]
    },
    devServer: {
        port: 8088,
        hot: true,
        static: './',
        //后台代理
        proxy: {
            '/api/': {
                target: 'http://192.168.168.213:8081',
                ws: true,
                secure: false,
                changeOrigin: true,
                pathRewrite: {
                    '^/api/': '/'
                }
            },
            '/websocket/**': {
                target: 'ws://192.168.168.213:8081',
                ws: true,
                secure: false,
                logLevel: 'debug',
            },
            '/api_exame/': {
                target: 'http://192.168.168.110:9005',
                pathRewrite: {
                    '^/api_exame/': '/'
                }
            },
            '/api_map/': {
                target: 'http://192.168.168.110:6080',
                pathRewrite: {
                    '^/api_map/': '/'
                }
            },
            '/api_wmts/': {
                target: 'http://192.168.168.213:8080',
                pathRewrite: {
                    '^/api_wmts/': '/'
                }
            },
            '/api_technique_emotion/': {
                target: 'http://192.168.168.212:7550',
                pathRewrite: {
                    '^/api_technique_emotion/': '/'
                }
            },
            '/api_technique_hotWord/': {
                target: 'http://192.168.168.212:9930',
                pathRewrite: {
                    '^/api_technique_hotWord/': '/'
                }
            }
        }
    }
}