import { get, post, addParam } from "../../util/http_util";

const PREFIX_RECORDS = 'api/rest/chat/chatRecords';

//分页查询群聊记录 
//查询小群
export const getRecordsByPagingTeam = (chatRoomId, currPage, pageSize, startTime, endTime, fromUserId,teamId) => {
    let url = `${PREFIX_RECORDS}/chatroomTeam/page`;
    url += addParam({ chatRoomId, currPage, pageSize, startTime, endTime, fromUserId,teamId });
    return get(url);
}

//查询大群
export const getRecordsByPaging = (chatRoomId, currPage, pageSize, startTime, endTime, fromUserId,teamId) => {
    let url = `${PREFIX_RECORDS}/chatroom/page`;
    url += addParam({ chatRoomId, currPage, pageSize, startTime, endTime, fromUserId,teamId });
    return get(url);
}

//分页查询私信信息
export const getPrivateLetterByPaging = (currPage, pageSize, startTime, endTime, userId1, userId2) => {
    let url = `${PREFIX_RECORDS}/direct`;
    url += addParam({ currPage, pageSize, startTime, endTime, userId1, userId2 });
    return get(url);
}

//查询群聊中未读信息
export const getListUnread = (chatRoomId, userId) => {
    return get(`${PREFIX_RECORDS}/listUnread?chatRoomId=${chatRoomId}&userId=${userId}`);
}