/*jshint esversion: 6 */

const extent = {
    "xmin": 113.09004255293418,
    "ymin": 23.00746200017774,
    "xmax": 113.25218690137116,
    "ymax": 23.093389052873547,
    "spatialReference": { "wkid": 4326 }
};
const ARCGISTiledMapServiceLayers = [{ url: "http://cache1.arcgisonline.cn/arcgis/rest/services/ChinaOnlineCommunity/MapServer" }];

const API_JS = "http://192.168.168.211/arcgis_js_api/library/3.23/3.23/init.js";
const API_CSS = "http://192.168.168.211/arcgis_js_api/library/3.23/3.23/esri/css/esri.css";

// import esriLoader from 'esri-loader';

import { loadCss, loadModules, setDefaultOptions } from 'esri-loader';
setDefaultOptions({ url: API_JS, css: API_CSS });
// 加载css
// loadCss (API_CSS);
var option = {
    // url: API_JS, // 制定路径加载arcgis的js，需指向init.js的路径
    dojoConfig: {  // 配置dojo
        // baseUrl: "http://61.155.110.210:7004/arcgis_js_api/library/3.23/3.23/3.23/"  // 需指向dojo目录
    }
}

var loadMap = function (id) {
    return new Promise(function (reslove, reject) {
        // 加载模块
        loadModules([
            "esri/map",
            "esri/layers/ArcGISTiledMapServiceLayer",
            "esri/geometry/Extent",
            "esri/geometry/Polyline",
            "esri/geometry/Polygon",
            "esri/geometry/webMercatorUtils",
            "esri/layers/GraphicsLayer",
            "esri/symbols/SimpleLineSymbol",
            "esri/symbols/PictureMarkerSymbol",
            "esri/geometry/Point",
            "esri/graphic",
            "esri/symbols/Font",
            "esri/Color",
            "esri/symbols/SimpleFillSymbol",
            "esri/symbols/SimpleMarkerSymbol",
            "esri/toolbars/draw",
            "esri/toolbars/edit",
            "esri/symbols/TextSymbol",
            "esri/tasks/JobInfo",
            "esri/tasks/Geoprocessor",
            "esri/renderers/BlendRenderer",
            "esri/tasks/FeatureSet",
            "esri/tasks/RouteTask",
            "esri/tasks/RouteParameters"
        ], option).then(function ([
            Map,
            ArcGISTiledMapServiceLayer,
            Extent,
            Polyline,
            Polygon,
            webMercatorUtils,
            GraphicsLayer,
            SimpleLineSymbol,
            PictureMarkerSymbol,
            Point,
            Graphic,
            Font,
            Color,
            SimpleFillSymbol,
            SimpleMarkerSymbol,
            Draw,
            Edit,
            TextSymbol,
            JobInfo,
            Geoprocessor,
            BlendRenderer,
            FeatureSet,
            RouteTask,
            RouteParameters
        ]) {

            //网络分析服务返回最短路径
            var naServer = function (stops, barriers, callback) {
                //下面这行给stops赋值是临时测试用，实际情况下请注释掉
                // stops = [[113.004060209646, 23.1202421874311], [113.005108953371, 23.1246847875103]];
                var routeTask = new RouteTask("http://44.64.177.138:6080/arcgis/rest/services/NanHai_RYLW/NAServer/Route");
                var routeParams = new RouteParameters();
                routeParams.outSpatialReference = { "wkid": 4326 };
                //暂停点
                routeParams.stops = new FeatureSet();
                for (var i = 0; i < stops.length; i++) {
                    routeParams.stops.features.push(
                        new Graphic(
                            new Point(stops[i][0], stops[i][1])
                        )
                    );
                }
                //障碍点
                routeParams.barriers = new FeatureSet();
                for (var j = 0; i < barriers.length; j++) {
                    routeParams.barriers.features.push(
                        new Graphic(
                            new Point(barriers[j][0], barriers[j][1])
                        )
                    );
                }
                routeTask.on("solve-complete", function (evt) {
                    callback(evt.result);
                });
                routeTask.on("error", function (err) {
                    callback();
                });
                routeTask.solve(routeParams);
            };

            //map容器
            var map = new Map(id, {
                extent: webMercatorUtils.geographicToWebMercator(extent),
                logo: false,
                // maxZoom: 20,//最大空间等级
                // minZoom: minzoom,//最小空间等级
            });
            // 绑定加载事件
            dojo.connect(map, "onLoad", function (mp) {
                reslove({
                    mp,
                    util: {
                        Map,
                        GraphicsLayer,
                        naServer,
                        Polyline,
                        Polygon,
                        Point,
                        Graphic,
                        SimpleMarkerSymbol,
                        PictureMarkerSymbol
                    }
                });
            });
            for (var i = 0; i < ARCGISTiledMapServiceLayers.length; i++) {
                var myTiledMapServiceLayer = new ArcGISTiledMapServiceLayer(ARCGISTiledMapServiceLayers[i].url);
                map.addLayer(myTiledMapServiceLayer);
            }
        }).catch((err) => {
            reject(err);
        });
    });
};

export {
    extent,
    ARCGISTiledMapServiceLayers,
    API_JS,
    API_CSS,
    loadMap
};