import { get, post, delete_util, fileUpload_PUT, addParam } from "../../util/http_util";

const PREFIX_DOCUMENT = "api/rest/3z/document/";
const PREFIX_RESOURCE = "api/rest/3z/resource/";


// 查询关注
export const queryAttention = (pageNum, pageSize, content) => {
    let url = `${PREFIX_RESOURCE}queryAttention`;
    url += addParam({ pageNum, pageSize, content });
    return get(url);
}

// 编辑数据
export const updateAttention = (data) => {
    return post(`${PREFIX_RESOURCE}updateAttention`, data);
}

// 删除关注
export const removeAttention = (id) => {
    return delete_util(`${PREFIX_RESOURCE}removeAttention/${id}`);
}

// 新增数据
export const addAttention = (data) => {
    return post(`${PREFIX_RESOURCE}addAttention`, data);
}