import JSZipUtils from 'jszip-utils';
import Docxtemplater from 'docxtemplater'
import { saveAs } from 'file-saver'
import JSZip from 'jszip'
import ImageModule from 'docxtemplater-image-module-free'

let blobToDataURI=(blob, callback)=>{
    var reader = new FileReader();
    reader.readAsDataURL(blob);
    reader.onload = function (e) {
        callback(e.target.result);
    }
 }

//转换图片格式
let base64DataURLToArrayBuffer = (dataURL) => {
    const base64Regex = /^data:image\/(png|jpg|svg|svg\+xml);base64,/;
    if (!base64Regex.test(dataURL)) {
        return false;
    }
    const stringBase64 = dataURL.replace(base64Regex, "");
    let binaryString;
    if (typeof window !== "undefined") {
        binaryString = window.atob(stringBase64);
    } else {
        binaryString = new Buffer(stringBase64, "base64").toString("binary");
    }
    const len = binaryString.length;
    const bytes = new Uint8Array(len);
    for (let i = 0; i < len; i++) {
        const ascii = binaryString.charCodeAt(i);
        bytes[i] = ascii;
    }
    return bytes.buffer;
}

//将html页面导出为word文件  templateUrl：word模板的位置   data：传的数据   wordName:导出的文件名称
export default (templateUrl, data, wordName, isDownload) => {
    return new Promise((resolve,reject)=>{
        if (wordName == '') {
            throw "文件名不能为空";
        }
        // 读取并获得模板文件的二进制内容
        JSZipUtils.getBinaryContent(templateUrl, (error, content) => {
            // 抛出异常
            if (error) {
                throw error
            }
            // 图片处理
            let opts = {}
            opts.centered = true; // 图片居中，在word模板中定义方式为{%%image}
            opts.fileType = "docx";
            opts.getImage = (chartId) => {
                return base64DataURLToArrayBuffer(chartId);
            }
            opts.getSize = () => {
                return [600, 250]
            }
            let imageModule = new ImageModule(opts);
            // 创建一个JSZip实例，内容为模板的内容
            let zip = new JSZip(content)
            // 创建并加载docxtemplater实例对象
            let doc = new Docxtemplater();
            doc.loadZip(zip);
            doc.attachModule(imageModule);
            // 设置模板变量的值
            doc.setData(data)
            try {
                // 用模板变量的值替换所有模板变量
                doc.render()
            } catch (error) {
                Message.error('导出报表失败');
                throw error
            }
            // 生成一个代表docxtemplater对象的zip文件（不是一个真实的文件，而是在内存中的表示）
            let out = doc.getZip().generate({
                type: 'Blob',
                mimeType: 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
            })
            if(isDownload==1){
                // 将目标文件对象保存为目标类型的文件，并命名
            saveAs(out, wordName + '.docx')
            resolve()
            }else if(isDownload == 0){
                blobToDataURI(out,aa=>{
                    resolve(aa);
                })
            };
        });
    });

    
}