import { get, post, addParam } from "../util/http_util";

const PREFIX_RECORDS = 'api/rest/chat/chatRecords';

//分页查询群聊记录
export const getRecordsByPaging = (chatRoomId, currPage, pageSize, startTime, endTime, fromUserId) => {
    let url = `${PREFIX_CHATROOM}/chatRecords/page`;
    url += addParam({ chatRoomId, currPage, pageSize, startTime, endTime, fromUserId });
    return get(url);
}

//分页查询私信信息
export const getPrivateLetterByPaging = (currPage, pageSize, startTime, endTime, userId1, userId2) => {
    let url = `${PREFIX_CHATROOM}/chatRecords/direct`;
    url += addParam({ currPage, pageSize, startTime, endTime, userId1, userId2 });
    return get(url);
}

//查询群聊中未读信息
export const getListUnread = (chatRoomId, userId) => {
    return get(`${PREFIX_RECORDS}/chatRecords/listUnread?chatRoomId=${chatRoomId}&userId=${userId}`);
}