import { get, post, delete_util, fileUpload_PUT, addParam } from "../../util/http_util";

const PREFIX_DOCUMENT = "api/rest/3z/document/";
const PREFIX_RESOURCE = "api/rest/3z/resource/";
const PREFIX_ELASTIC = "api/rest/elastic/";


export const queryDoc = (pageNum, pageSize, params) => {
    return post(`${PREFIX_DOCUMENT}queryDoc?pageNum=${pageNum}&pageSize=${pageSize}`, params);
}


export const searchFiles = (pageNum, pageSize, params) => {
    return post(`${PREFIX_ELASTIC}searchFiles?pageNum=${pageNum}&pageSize=${pageSize}`, params);
}

export const queryDocumentTree = (module) => {
    return get(`${PREFIX_DOCUMENT}queryDocumentTree?module=${module}`);
}

export const updateDocumentTreeItem = (data) => {
    return post(`${PREFIX_DOCUMENT}updateDocumentTreeItem`,data);
}

export const addDocumentTreeItem = (data) => {
    return post(`${PREFIX_DOCUMENT}addDocumentTreeItem`,data);
}

export const removeDocumentTreeItem = (id) => {
    return delete_util(`${PREFIX_DOCUMENT}removeDocumentTreeItem/${id}`);
}

