/*jshint esversion: 6 */

// var tileLayers = [{ url: "http://192.168.168.110:6080/arcgis/rest/services/World_YX/MapServer" }];
const TILE_LAYTERS = [{ url: "http://cache1.arcgisonline.cn/arcgis/rest/services/ChinaOnlineCommunity/MapServer" }];
const API_JS = "http://61.155.110.210:7004/arcgis_js_api/library/4.14/init.js";
const API_CSS = "http://61.155.110.210:7004/arcgis_js_api/library/4.14/esri/css/main.css";

import { loadCss, loadModules } from 'esri-loader';

// 加载css
loadCss(API_CSS);
var option = {
    url: API_JS, // 制定路径加载arcgis的js，需指向init.js的路径
    dojoConfig: {  // 配置dojo
        // baseUrl: "http://61.155.110.210:7004/arcgis_js_api/library/3.23/3.23/3.23/"  // 需指向dojo目录
    }
}

var load2DMap = function (id) {
    return new Promise(function (reslove, reject) {
        // 加载模块
        loadModules([
            "esri/Map",
            "esri/views/MapView",
            "esri/layers/TileLayer",
            "esri/layers/MapImageLayer",
            "esri/geometry/Extent"
        ], option).then(function ([
            Map,
            MapView,
            TileLayer,
            MapImageLayer,
            Extent
        ]) {
            var layers = [];
            for (var i = 0; i < TILE_LAYTERS.length; i++) {
                layers.push(new MapImageLayer({ url: TILE_LAYTERS[i].url }));
                // layers.push(new TileLayer({url:TileLayers[i].url}));
            }

            //map容器
            var map = new Map({
                basemap: "",
                layers: layers
            });

            var view = new MapView({
                container: id, // Reference to the DOM node that will contain the view
                map: map, // References the map object created in step 3
                // extent: new Extent(extent),
                center: [-121.4506, 31.2199],
                zoom: 5
            });

            reslove({
                Map

            });

        }).catch((err) => {
            reject(err);
        });
    });
};

var load3DMap = function (id) {
    return new Promise(function (reslove, reject) {
        // 加载模块
        loadModules([
            "esri/Map",
            "esri/views/SceneView",
            "esri/layers/TileLayer",
            "esri/geometry/Extent",
            "esri/layers/SceneLayer"
        ], option).then(function ([
            Map,
            SceneView,
            TileLayer,
            Extent,
            SceneLayer
        ]) {
            //底图图层
            var baseLayers = [];
            for (var i = 0; i < TILE_LAYTERS.length; i++) {
                baseLayers.push(new TileLayer({ url: TILE_LAYTERS[i].url }));
            }
            //map容器
            var map = new Map({
                basemap: "",
                ground: "world-elevation",
                layers: baseLayers
            });
            //场景图层
            var sceneLayer = new SceneLayer({
                //url: "https://tiles.arcgis.com/tiles/cNXlkTk36vCn8KGq/arcgis/rest/services/buildings_3D_JA/SceneServer",
                url: "https://tiles.arcgis.com/tiles/cNXlkTk36vCn8KGq/arcgis/rest/services/srs/SceneServer",
                opacity: 0.7,
                renderer: {
                    type: "simple",
                    symbol: {
                        type: "mesh-3d",
                        symbolLayers: [
                            {
                                type: "fill"
                            }
                        ]
                    },
                    visualVariables: [{
                        type: "color",
                        field: "结构类型",
                        stops: [{
                            value: 0,
                            color: "#a9bd4e",
                            label: "Old building"
                        },
                        {
                            value: 1,
                            color: "#41a1c6",
                            label: "New building"
                        },
                        {
                            value: 2,
                            color: "#fca754",
                            label: "New building"
                        },
                        {
                            value: 3,
                            color: "#db5f67",
                            label: "New building"
                        },
                        {
                            value: 4,
                            color: "#965595",
                            label: "New building"
                        }
                        ]
                    }]
                },
                popupTemplate: {
                    title: '{名称}',
                    content: [{
                        type: "fields",
                        fieldInfos: [{
                            fieldName: "OBJECTID",
                            label: "OBJECTID",
                            visible: true
                        }, {
                            fieldName: "OBJECTID_1",
                            label: "OBJECTID_1",
                            visible: true
                        }, {
                            fieldName: "层高",
                            label: "层高",
                            visible: true
                        }, {
                            fieldName: "道路名",
                            label: "道路名",
                            visible: true,
                            format: {
                                digitSeparator: true,
                                places: 0
                            }
                        }, {
                            fieldName: "所属单元",
                            label: "所属单元",
                            visible: true,
                            format: {
                                digitSeparator: true,
                                places: 0
                            }
                        }, {
                            fieldName: "建筑面积",
                            label: "建筑面积",
                            visible: true,
                            format: {
                                digitSeparator: true,
                                places: 0
                            }
                        }]
                    }]
                }
            });
            map.add(sceneLayer);
            //三维视图
            var view = new SceneView({
                container: id, // Reference to the DOM node that will contain the view
                map: map, // References the map object created in step 3
                camera: {
                    position: [121.4506, 31.2199, 1207],
                    tilt: 50,
                    heading: 15
                }
            });
            //回调触发
            reslove({
                Map

            });

        }).catch((err) => {
            reject(err);
        });
    });
};

export {
    load2DMap,
    load3DMap
};