//词云
export const option_hot_word = {
    title: {
      text: "热门词云",
      textStyle: {
        color: "#fff",
        fontSize: 12,
      },
      top: 10,
      left: 10,
    },
    series: [
      {
        type: "wordCloud",
        //用来调整词之间的距离
        gridSize: 10,
        //用来调整字的大小范围
        // Text size range which the value in data will be mapped to.
        // Default to have minimum 12px and maximum 60px size.
        sizeRange: [14, 60],
        // Text rotation range and step in degree. Text will be rotated randomly in range [-90,                                                                             90] by rotationStep 45
        //用来调整词的旋转方向，，[0,0]--代表着没有角度，也就是词为水平方向，需要设置角度参考注释内容
        // rotationRange: [-45, 0, 45, 90],
        // rotationRange: [ 0,90],
        rotationRange: [0, 0],
        //随机生成字体颜色
        // maskImage: maskImage,
        textStyle: {
          fontFamily: "微软雅黑",
          color: function () {
            return (
              "rgb(" +
              [
                Math.round((Math.random() * 50)+(Math.random() * 200)+50),
                Math.round((Math.random() * 50)+120),
                Math.round((Math.random() * 50)+(Math.random() * 200)+20),
              ].join(",") +
              ")"
            );
          },
        },
        left: "10%",
        top: "15%",
        right: "10%",
        width: "80%",
        height: "75%",
        //数据
        data: [],
      },
    ],
}
//饼图
export const option_pie = {
    tooltip: {
        trigger: "item",
    },
    legend: {
        top: "3%",
        left: "center",
        itemWidth:10,
        itemHeight:10,
        textStyle: {
            fontSize: 12,
            color: "#fff",
        },
    },
    series: [
        {
            name: "数据量",
            type: "pie",
            radius: ["35%", "50%"],
            center: ["50%", "60%"],
            avoidLabelOverlap: false,
            label: {
                //展示文本设置
                normal: {
                    show: true, //展示
                    textStyle: {
                    //文本样式
                    color: "#fff",
                    },
                },
            },
            emphasis: {
                label: {
                    show: true,
                    fontSize: "18",
                    fontWeight: "bold",
                },
            },
            data: [],
        },
    ],
}
//倒排
export const option_bar_desc = {
    title: {
      text: "飙升关键词",
      textStyle: {
        color: "#fff",
        fontSize: 12,
      },
      top: 10,
      left: 10,
    },
    grid: {
      top: "15%",
      left: "22%",
      right: "16%",
      bottom: "8%",
    },
    tooltip: {
      show: true,
      backgroundColor: "#fff",
      textStyle: {
        fontSize: 12,
        color: "#152934",
        lineHeight: 50,
      },
      formatter: function (params) {
        return params.name + "：" + params.data;
      },
    },
    xAxis: {
      show: false,
    },
    yAxis: {
      type: "category",
      data: [],
      inverse: true,
      axisLine: {
        show: false,
        interval: 0,
      },
      axisTick: {
        show: false,
      },
      axisLabel: {
        color: "#fff",
      },
    },
    series: [
      {
        type: "bar",
        yAxisIndex: 0,
        data: [],
        barWidth: 10,
        barGap: "-100%",
        label: {
          normal: {
            show: true,
            position: "right",
            formatter: function (value) {
              return value.value;
            },
            textStyle: {
              color: "#fff",
            },
          },
        },
        itemStyle: {
          normal: {
            // color: new echarts.graphic.LinearGradient(
            //   1,
            //   0,
            //   0,
            //   0,
            //   [
            //     {
            //       offset: 0,
            //       color: "#2ad5ff", // 0% 处的颜色
            //     },
            //     {
            //       offset: 0.6,
            //       color: "#058bf8", // 60% 处的颜色
            //     },
            //     {
            //       offset: 1,
            //       color: "#005ef5", // 100% 处的颜色
            //     },
            //   ],
            //   false
            // ),
          },
        },
      },
    ],
}

//战场环境态势-各国总量
export const option_vissiming =  {
  title: {
      show: false,
      text: '各国总量',
      top: '-2%',
      left: '10%',
      textStyle: {
          color: 'white'
      }
  },
  tooltip: {
      trigger: 'axis',
      axisPointer: {
          type: 'shadow'
      }
  },
  grid: {
      top:'0%',
      left: '3%',
      right: '4%',
      bottom: '3%',
      containLabel: true
  },
  xAxis: {
      type: 'value',
      boundaryGap: [0, 0.01],
      splitLine: {
          show: false
      },
      axisLabel: {
          textStyle: {
              color: 'white'
          }
      },
      // axisLine: {
      //     lineStyle: {
      //         color: '#127186',
      //         width: 5,//这里是为了突出显示加上的
      //     }
      // },

  },
  yAxis: {
      type: 'category',
      data: ['巴西', '印尼', '美国', '印度', '中国', '世界人口(万)'],
      axisLabel: {
          textStyle: {
              color: 'white'
          }
      },
      // axisLine: {
      //     lineStyle: {
      //         color: '#127186',
      //         width: 5,//这里是为了突出显示加上的
      //     }
      // },
      axisTick: {
          show: false
      },
  },
  series: [
      {
          type: 'bar',
          data: [18203, 23489, 29034, 104970, 131744, 630230],
          itemStyle: {
              color: '#34C0CF',
              // barBorderRadius: [20, 20, 20, 20]
          }
      }
  ]
}