/**
 * api统一管理
 */
import { get, post } from "../util/http_util";

//#region 公共
/**
 * 添加param
 * @param {*} param 
 * @returns 
 */
function addParam(param) {
    let url = "";
    let keys = Object.getOwnPropertyNames(param);
    keys.forEach(function (key, index) {
        if (param[key] != undefined) {
            if (index == 0) {
                url += "?";
            }
            url += key + "=" + param[key];
            if (index != keys.length - 1) {
                url += "&";
            }
        }
    });
    return url;
}
//#endregion

export function queryDynamicCharacter(pageNum, pageSize, param) {
    return post(
        `api/rest/resource/queryDynamicCharacter?pageNum=${pageNum}&pageSize=${pageSize}`, param)
}

export function queryDynamicOrganization(pageNum, pageSize, param) {
    return post(
        `api/rest/resource/queryDynamicOrganization?pageNum=${pageNum}&pageSize=${pageSize}`, param)
}


/**
 * 根据条件查询新闻
 */
export function queryNews(pageNum = 1, pageSize = 10, body = {}) {
    return post("api/rest/fulltext/queryNews?pageSize=20", {});
}

/**
 * 辅助决策文件查询
 * @param {*} pageNum 
 * @param {*} pageSize 
 * @param {*} body 
 * @returns 
 */
export function queryDoc(pageNum = 1, pageSize = 10, body = {}) {
    return post(`api/rest/document/queryDoc?pageNum=${pageNum}&pageSize=${pageSize}`, body);
}

/**
 * 
 */
export function queryAttention() {
    return get("api/rest/resource/queryAttention");
}

/**
 * 查询舆情分析
 */
export function queryYqfx(module, list) {
    return post(`api/rest/document/multiQueryLiterature?module=${module}`, list);
}

/**
 * 查询新闻详情
 */
export function queryNewsInfo(id) {
    return get("api/rest/fulltext/queryOneNews?Id=" + id);
}

/**
 * 查询辅助决策树结构
 */
export function queryFzjcTree(module) {
    return get(`api/rest/document/queryDocumentTree?module=${module}`)
}

/**
 * 查询舆情热点
 */
export function queryTopicNews(modules) {
    return post(`api/rest/fulltext/multiTopicQueryNews`, modules)
}

/**
 * 查询报告
 */
export function queryReport(pageNum, pageSize, name, startTime, endTime) {
    let url = `api/rest/sentiment/queryReport`;
    url += addParam({ pageNum, pageSize, name, startTime, endTime });
    return get(url);
}

/**
 * 查询系统名称
 */
export function querySystemName() {
    let url = `api/rest/3z/dictitem/queryDictItem/06`;
    return get(url);
}