import { get, post, delete_util } from "../util/http_util";

//#region 公共
//服务前缀
const PREFIX = "api/rest/decision";
/**
 * 添加param
 * @param {*} param 
 * @returns 
 */
function addParam(param) {
    let url = "";
    let keys = Object.getOwnPropertyNames(param);
    keys.forEach(function (key, index) {
        if (param[key] != undefined) {
            if (index == 0) {
                url += "?";
            }
            url += key + "=" + param[key];
            if (index != keys.length - 1) {
                url += "&";
            }
        }
    });
    return url;
}
//#endregion

/**
 * 查询分析研判
 * @param {*} pageNum 
 * @param {*} pageSize 
 * @param {*} queryParam 
 * @returns 
 */
export function queryDecisionSituationAnalysisJudgment(pageNum, pageSize, queryParam) {
    return post(`${PREFIX}/queryDecisionSituationAnalysisJudgment?pageNum=${pageNum}&pageSize=${pageSize}`, queryParam);
}

/**
 * 新增分析研判
 * @param {*} source 
 * @param {*} competitorsSituation 
 * @param {*} competitorsPurpose 
 * @param {*} legalIllegal 
 * @param {*} currentSituations
 * @param {*} nextImpact 
 * @param {*} content
 * @returns 
 */
export function addDecisionSituationAnalysisJudgment(param) {
    return post(`${PREFIX}/addDecisionSituationAnalysisJudgment`, param);
}

/**
 * 删除分析研判
 * @param {*} ids 
 * @returns 
 */
export function removeDecisionSituationAnalysisJudgment(ids) {
    return delete_util(`${PREFIX}/removeDecisionSituationAnalysisJudgment`, ids);
}



/**
 * 查询措施建议
 * @param {*} pageNum 
 * @param {*} pageSize 
 * @param {*} queryParam 
 * @returns 
 */
export function queryMeasuresSuggested(pageNum, pageSize, queryParam) {
    return post(`${PREFIX}/queryMeasuresSuggested?pageNum=${pageNum}&pageSize=${pageSize}`, queryParam);
}

/**
 * 新增措施建议
 * @param {*} content 
 * @param {*} copingChannel 
 * @param {*} copingStrategies 
 * @param {*} copingStrength 
 * @param {*} object
 * @returns 
 */
export function addMeasuresSuggested(param) {
    return post(`${PREFIX}/addMeasuresSuggested`, param);
}

/**
 * 删除措施建议
 * @param {*} ids 
 * @returns 
 */
export function removeMeasuresSuggested(ids) {
    return delete_util(`${PREFIX}/removeMeasuresSuggested`, ids);
}

/**
 * 查询信息制品
 * @param {*} pageNum 
 * @param {*} pageSize 
 * @param {*} queryParam 
 * @returns 
 */
export function queryDecisionInformationProduct(pageNum, pageSize, queryParam) {
    return post(`${PREFIX}/queryDecisionInformationProduct?pageNum=${pageNum}&pageSize=${pageSize}`, queryParam);
}

/**
 * 新增信息制品
 * @param {*} cal 
 * @param {*} content 
 * @param {*} copingChannel 
 * @param {*} copingStrategies 
 * @param {*} copingStrength
 * @param {*} issues 
 * @param {*} object 
 * @param {*} productCode
 * @param {*} productDelivery
 * @returns 
 */
export function addDecisionInformationProduct(param) {
    return post(`${PREFIX}/addDecisionInformationProduct`, param);
}

/**
 * 删除信息制品
 * @param {*} ids 
 * @returns 
 */
export function removeDecisionInformationProduct(ids) {
    return delete_util(`${PREFIX}/removeDecisionInformationProduct`, ids);
}


/**
 * 查询国家
 * @returns 
 */
export function queryCountry() {
    return get(`${PREFIX}/queryCountry`);
}

/**
 * 查询制作简报
 * @param {*} pageNum 
 * @param {*} pageSize 
 * @param {*} name 
 * @returns 
 */
export function queryBriefing(pageNum, pageSize, name) {
    let url = `api/rest/document/queryBriefing`;
    url += addParam({ pageNum, pageSize, name });
    return get(url);
}

/**
 * 简报删除
 * @param {*} paths 
 * @returns 
 */
export function removeBriefing(paths) {
    return delete_util(`api/rest/document/removeBriefing`, paths);
}

/**
 * 生成预案
 * @param {*} content
 * @param {*} result 
 * @returns 
 */
 export function saveResult(param) {
    return post(`api/rest/decision/saveResult`, param);
}

/**
 * 查询预案
 * @param {*} pageNum 
 * @param {*} pageSize 
 * @param {*} content
 * @returns 
 */
 export function queryResult(pageNum, pageSize, content) {
    let url = `api/rest/decision/queryResult`;
    url += addParam({ pageNum, pageSize});
    return post(url, content);
}

/**
 * 删除预案
 * @param {*} ids 
 * @returns 
 */
 export function removeResult(ids) {
    return delete_util(`api/rest/decision/removeResult`, ids);
}