import { get, post, addParam } from "../util/http_util";

const PREFIX_CHATROOM = 'api/rest/chat/chatroom';

//增加聊天室（群组）议题
export const addIssue = data => {
    return post(`${PREFIX_CHATROOM}/addIssue`, data);
}

//创建聊天室(群组)
export const createChatRoom = data => {
    return post(`${PREFIX_CHATROOM}/create`, data);
}

//查询某个聊天室（群组）详情信息
export const getChatRoomInfo = id => {
    return get(`${PREFIX_CHATROOM}/info?id=${id}`);
}

//加入聊天室（群组）
export const joinChatRoom = (chatRoomId, userId) => {
    return get(`${PREFIX_CHATROOM}/join?chatRoomId=${chatRoomId}&userId=${userId}`);
}

//离开聊天室（群组）
export const leaveChatRoom = (userId) => {
    return get(`${PREFIX_CHATROOM}/leave?chatRoomId=${id}&userId=${userId}`);
}

//查询某个用户所有聊天室（群组）
export const getChatRoomList = (userId) => {
    return get(`${PREFIX_CHATROOM}/list?userId=${userId}`);
}

//阅读（群组）信息
export const readChatRoom = (chatRoomId,userId) => {
    return get(`${PREFIX_CHATROOM}/readChatRoom?chatRoomId=${chatRoomId}&userId=${userId}`);
}

//设置聊天室（群组）当前议题
export const setChatRoomCurrentIssue = (chatRoomId,currentIssue) => {
    return get(`${PREFIX_CHATROOM}/setChatRoomCurrentIssue?chatRoomId=${chatRoomId}&currentIssue=${currentIssue}`);
}

//设置聊天室（群组）状态
export const setChatRoomStatus = (chatRoomId) => {
    return get(`${PREFIX_CHATROOM}/setChatRoomStatus?chatRoomId=${chatRoomId}`);
}








