import * as turf from "./lib/turf"
// import * as turf from "@turf/turf"
import GeoJSON from 'ol/format/GeoJSON'
var turfFormat = new GeoJSON()

export function getTurfArcFeature(start, end, opt) {
    let line = turf.lineString([
        start,
        [start[0] + (end[0] - start[0]) * 0.5,
        start[1] + (end[1] - start[1]) * 0.65],
        end
    ]);
    let curved = turf.bezierSpline(line);
    let length = turf.length(curved, { units: 'meters' });
    let bF = turfFormat.readFeature(curved);
    // bF.getGeometry().transform('EPSG:4326', 'EPSG:3857');
    bF.setProperties(opt);
    bF.set("length", length);
    return bF;
}

export function getTurfArcFeatures(coords, opt) {
    let line = turf.lineString(coords[0]);
    var curved1;
    if (opt && opt.resolution) {
        curved1 = turf.bezierSpline(line, { resolution: opt.resolution });
    } else {
        curved1 = turf.bezierSpline(line);
    }
    let length = turf.length(curved1, { units: 'meters' });
    let bF = turfFormat.readFeature(curved1);
    bF.setProperties(opt);
    bF.set("length", length);
    return bF;
}

/**
 * 两点之间的弧度角
 * @param {} start
 * @param {*} end 
 * @returns 
 */
export function degreesToRadians(start, end) {
    let bearing = turf.bearing(start, end);
    return turf.degreesToRadians(bearing);
}

/**
 * 线段根据距离分割成多个线段集合
 * @param {*} data 
 * @returns 
 */
export function lineChunk(data) {
    let line = turf.lineString(data);
    let chunk = turf.lineChunk(line, 0.2, { units: 'kilometers' });
    return chunk;
}

/**
 * 角度转弧度
 * @param {*} degrees 
 * @returns 
 */
export function degreesToRadians1(degrees){
    return turf.degreesToRadians(degrees);
}