import Vue from 'vue'
import Router from 'vue-router'
import store from '../store'
import { getQueryString } from "../util/url_util"
import { loginByToken } from "../util/login_util"


//解决ElementUI导航栏中的vue-router在3.0版本以上重复点菜单报错问题
// const originalPush = Router.prototype.push
// Router.prototype.push = function push(location) {
//     return originalPush.call(this, location).catch(err => err)
// }
const originalPush = Router.prototype.push;
const originalReplace = Router.prototype.replace; 

// push
Router.prototype.push = function push(location, onResolve, onReject) {
  if (onResolve || onReject)
    return originalPush.call(this, location, onResolve, onReject);
  return originalPush.call(this, location).catch(err => err);
};

//replace
Router.prototype.replace = function push(location, onResolve, onReject) {
  if (onResolve || onReject)
    return originalReplace.call(this, location, onResolve, onReject);
  return originalReplace.call(this, location).catch(err => err);
};
Vue.use(Router);

//静态路由
const constantRoutes = [{
    path: '/login',
    name: '登录',
    component: () => import('../view/login.vue')
}, {
    path: '/homepage',
    name: '模块页面',
    component: () => import('../view/homepage.vue')
}, {
    path: '/visualizing',
    name: '大屏展示',
    component: () => import('../view/visualizing.vue')
}, {
    path: '/chatRoom',
    name: '学习训练平台',
    component: () => import('../view/chatRoom.vue')
}, {
    path: '/dfzyrwxq',
    name: '敌方人物详情',
    component: () => import('../view/dfzyrwxq.vue')
}, {
    path: '/dfzyjgxq',
    name: '敌方机构详情',
    component: () => import('../view/dfzyjgxq.vue')
}];

//初始化路由实例
let router = new Router({
    routes: constantRoutes
});

//404页面，当用户输入错误的url时，作为中转页面会跳转到首页
const errorRoute = {
    path: '*',
    name: '404',
    component: () => import('../view/404.vue')
};


//路由守卫
router.beforeEach((to, from, next) => {
    window.document.title = to.name;
    //游客请求
    if (to.path == '/login' || to.path == '/visualizing' || to.path == '/chatRoom' || to.path == '/dfzyrwxq' || to.path == '/dfzyjgxq') {
        next();
    } //非游客已经登录请求
    else if (sessionStorage.getItem('isLogin') == 'true') {
        //登陆后没有放值
        if (!store.state.navList.length) {
            store.dispatch('setUserInfo', JSON.parse(sessionStorage.getItem("user")));
            store.dispatch('getNavList').
                then((e) => {
                    //e是home路由
                    router.addRoute(e);
                    router.addRoute(errorRoute);
                    next({
                        ...to,
                        replace: true
                    });
                }).
                catch(err => {
                    //在统一登录的时候需要手动清除登陆状态，否则第一次登录失效后无法通过token链接登录
                    sessionStorage.setItem("isLogin", false);
                    next({
                        name: '登录',
                        params: err
                    });
                });
        } else {
            next();
        }
    }//token登录
    else if (getQueryString("ticket_token")) {
        let token = getQueryString("ticket_token");
        loginByToken(token)
            .then(res => {
                next({
                    ...to,
                    replace: true
                });
            }).catch(err => {
                next({
                    name: '登录',
                    params: err
                });
            });
    }
    //非游客未登录请求
    else {
        next('/login');
    }
});

export default router