import { get, post,delete_util } from "../util/http_util";

//#region 公共
//服务前缀
const PREFIX = "api/rest/3z/resource";
const PREFIX_Sentiment = "api/rest/sentiment";
/**
 * 添加param
 * @param {*} param 
 * @returns 
 */
function addParam(param) {
    let url = "";
    let keys = Object.getOwnPropertyNames(param);
    keys.forEach(function (key, index) {
        if (param[key] != undefined) {
            if (index == 0) {
                url += "?";
            }
            url += key + "=" + param[key];
            if (index != keys.length - 1) {
                url += "&";
            }
        }
    });
    return url;
}
//#endregion

//#region 想定作业8/10
/**
 * 目录树查询
 * @returns 
 */
export function queryQuestionTree() {
    return get(`${PREFIX}/queryQuestionTree`);
}

/**
 * 题目查询
 * @param {*} pageNum 
 * @param {*} pageSize 
 * @param {*} content 
 * @param {*} treeId 
 * @returns 
 */
export function queryQuestion(pageNum, pageSize, content, treeId) {
    let url = `${PREFIX}/queryQuestion`;
    url += addParam({ pageNum, pageSize, content, treeId });
    return get(url);
}

/**
 * 答题
 * @param {*} body 
 * @returns 
 */
export function answerQuestion(body) {
    return post(`${PREFIX}/answerQuestion`, body);
}

/**
 * 选项查询
 * @returns 
 */
export function queryQuestionOptions() {
    return get(`${PREFIX}/queryQuestionOptions`);
}

/**
 * 历史答题记录
 * @param {*} questionId 
 * @param {*} pageNum 
 * @param {*} pageSize 
 * @returns 
 */
export function queryAnswerQuestionRecord(questionId, pageNum, pageSize) {
    let url = `${PREFIX}/queryAnswerQuestionRecord`;
    url += addParam({ questionId, pageNum, pageSize });
    return get(url);
}

/**
 * 新增题目
 * @param {*} treeId 
 * @param {*} name 
 * @param {*} content 
 * @param {*} analysis 
 * @param {*} measure 
 * @returns 
 */
 export function addNewQuestion(param){
    return post(`${PREFIX}/addQuestion`,param);
}

/**
 * 编辑题目
 * @param {*} treeId 
 * @param {*} name 
 * @param {*} content 
 * @param {*} analysis 
 * @param {*} measure 
 * @returns 
 */
 export function UpdateQuestion(param){
    return post(`${PREFIX}/updateQuestion`,param);
}

/**
 * 想定作业新增作业树节点
 * @param {*} code
 * @param {*} id 
 * @param {*} label 
 * @param {*} parentCode
 * @returns 
 */
 export function addQuestionTreeNode(param){
    return post(`${PREFIX}/addQuestionTreeNode`,param);
}

/**
 * 想定作业编辑作业树节点
 * @param {*} code
 * @param {*} id 
 * @param {*} label 
 * @param {*} parentCode
 * @returns 
 */
 export function updateQuestionTreeNode(param){
    return post(`${PREFIX}/updateQuestionTreeNode`,param);
}

/**
 * 想定作业删除作业树节点
 * @param {*} id 
 * @returns 
 */
 export function removeQuestionTreeNode(id){
    return delete_util(`${PREFIX}/removeQuestionTreeNode?id=${id}`);
}

/**
 * 想定作业批量删除题目
 * @param {*} ids
 * @returns 
 */
 export function removeQuestion(ids){
    return delete_util(`${PREFIX}/removeQuestion`,ids);
}

/**
 * 想定作业查询选项树
 * @returns 
 */
 export function queryQuestionOptionsTree(type){
    return get(`${PREFIX}/queryQuestionOptionsTree?type=${type}`);
}

/**
 * 舆情资讯库新增站点
 * @param {*} countryEn
 * @param {*} countryZh
 * @param {*} domain
 * @param {*} name
 * @returns 
 */
 export function addWebsite(param){
    return post(`${PREFIX_Sentiment}/addWebsite`,param);
}

/**
 * 舆情资讯库删除站点
 * @param {*} ids
 * @returns 
 */
 export function removeWebsite(ids){
    return delete_util(`${PREFIX_Sentiment}/removeWebsite`,ids);
}

/**
 * 舆情资讯库编辑站点
 * @param {*} countryEn
 * @param {*} countryZh
 * @param {*} domain
 * @param {*} name
 * @returns 
 */
 export function editWebsite(ids){
    return post(`${PREFIX_Sentiment}/updateWebsite`,ids);
}

/**
 * 舆情资讯库新增国家
 * @param {*} parentid
 * @param {*} name
 * @returns 
 */
 export function addCountry(param){
    return post(`${PREFIX_Sentiment}/addSource`,param);
}

/**
 * 舆情资讯库编辑国家
 * @param {*} id
 * @param {*} name
 * @returns 
 */
 export function editCountry(param){
    return post(`${PREFIX_Sentiment}/updateSource?id=${param.id}&name=${param.name}`);
}

/**
 * 舆情资讯库删除国家
 * @param {*} id
 * @returns 
 */
 export function removeCountry(id){
    return post(`${PREFIX_Sentiment}/removeSource?id=${id}`);
}

/**
 * 想定作业新增选项树节点
 * @param {*} label
 * @param {*} type
 * @param {*} parentId
 * @returns 
 */
 export function addQuestionOptionsTreeNode(label,type,parentId){
    let url = `${PREFIX}/addQuestionOptionsTreeNode`;
    url += addParam({ label, type, parentId});
    return post(url);
}

/**
 * 想定作业删除作业树节点
 * @param {*} id
 * @returns 
 */
 export function removeQuestionOptionsTreeNode(id){
    return delete_util(`${PREFIX}/removeQuestionOptionsTreeNode?id=${id}`);
}

/**
 * 想定作业编辑选项树节点
 * @param {*} label
 * @param {*} id
 * @returns 
 */
 export function updateQuestionOptionsTreeNode(label,id){
    return post(`${PREFIX}/updateQuestionOptionsTreeNode?label=${label}&id=${id}`);
}
//#endregion