import React, { Component, Suspense } from 'react';
import { useNavigate, useLocation, useResolvedPath } from "react-router-dom";
import { Outlet } from 'react-router-dom'
import { checkRouterAuth } from './index'
import { useEffect, useState } from 'react'

const RouterBeforeEach = (props) => {
    const navigate = useNavigate()
    const location = useLocation()
    const [auth, setAuth] = useState(false)
    useEffect(() => {
        console.log(location);
        let obj = checkRouterAuth(location.pathname)
        let blLogin = sessionStorage.getItem('login')
        if (blLogin != 'true') {
            setAuth(false)
            navigate('/login', { replace: true })
        } else {
            setAuth(true)
        }
    }, [])
    return auth ? <Outlet /> : null
}

export default RouterBeforeEach