import React from "react";
import { Breadcrumb, Input, Tree, Table, Tag, Space } from 'antd';
const { Search } = Input;
import '../index.css';
import { DoubleRightOutlined, DownOutlined } from '@ant-design/icons';
const STYLE = {
    Container: {
        width: "100%",
        height: "100%",
        Header: {
            width: "100%",
            height: "60px",
            padding: "15px",
            color: "white",
            Breadcrumb: {
                width: "250px",
                height: "30px",
                float: "left",
                fontSize: "16px",
                color: "white",
                Icon: {
                    fontSize: "16px",
                    fontWeight: "600"
                }
            },
            Search: {
                width: "40%",
                float: "right"
            }
        },
        Content: {
            width: "100%",
            height: "calc(100% - 60px)",
            padding: "10px",
            LeftContent: {
                width: "200px",
                height: "100%",
                float: "left",
                padding: "5px",
                border: "1px solid #2d375e",
                backgroundImage: "url(../../../public/img/8.png)",
                boxShadow: "black 2px 2px 3px"
            },
            RightContent: {
                width: "calc(100% - 220px)",
                height: "100%",
                float: "left",
                marginLeft: "20px",
                padding: "10px",
                border: "1px solid #2d375e",
                backgroundImage: "url(../../../public/img/8.png)",
                boxShadow: "black 2px 2px 3px"
            }
        }
    }
}

export default () => {

    const onSearch = (value) => console.log(value);

    const onSelect = (selectedKeys, info) => {
        console.log('selected', selectedKeys, info);
    };

    const treeData = [
        {
            title: '基础设施',
            key: '0-0',
            children: [
                {
                    title: '公路',
                    key: '0-0-0'
                },
                {
                    title: '水路',
                    key: '0-0-1',

                },
                {
                    title: '轨迹',
                    key: '0-0-2',
                },
                {
                    title: '场站',
                    key: '0-0-3',
                },
            ]
        },
        {
            title: '道路运输',
            key: '1-0'
        }
        ,
        {
            title: '公共交通',
            key: '2-0'
        }
        ,
        {
            title: '水路运输',
            key: '3-0'
        }
    ];

    const columns = [
        {
            title: '序号',
            dataIndex: 'index',
            key: 'index',
            align: 'center'
        },
        {
            title: '名称',
            dataIndex: 'name',
            key: 'name',
            align: 'center'
        },
        {
            title: '编码(ID)',
            dataIndex: 'id',
            key: 'id',
            align: 'center'
        },
        {
            title: '类型',
            dataIndex: 'type',
            key: 'type',
            align: 'center'
        },
        {
            title: '管养单位',
            dataIndex: 'department',
            key: 'department',
            align: 'center'
        },
        {
            title: '位置',
            dataIndex: 'address',
            key: 'address',
            align: 'center'
        },
        {
            title: '定位',
            key: 'action',
            align: 'center',
            render: (_, record) => (
                <Space size="middle">
                    <a>
                        <img className="actionImg" src="../../../public/img/7.png"></img>
                    </a>
                </Space>
            ),
        },
    ];

    const data = [
        {
            key: '1',
            index: 1,
            name: '港口',
            id: 564536,
            type: '港口',
            department: '水路运输局',
            address: "水路运输局",
        },
        {
            key: '2',
            index: 2,
            name: '港口',
            id: 564536,
            type: '港口',
            department: '水路运输局',
            address: "水路运输局",
        },
        {
            key: '3',
            index: 3,
            name: '港口',
            id: 564536,
            type: '港口',
            department: '水路运输局',
            address: "水路运输局",
        },
        {
            key: '4',
            index: 4,
            name: '港口',
            id: 564536,
            type: '港口',
            department: '水路运输局',
            address: "水路运输局",
        },
        {
            key: '5',
            index: 5,
            name: '港口',
            id: 564536,
            type: '港口',
            department: '水路运输局',
            address: "水路运输局",
        },
        {
            key: '6',
            index: 6,
            name: '港口',
            id: 564536,
            type: '港口',
            department: '水路运输局',
            address: "水路运输局",
        },
        {
            key: '7',
            index: 7,
            name: '港口',
            id: 564536,
            type: '港口',
            department: '水路运输局',
            address: "水路运输局",
        },
        {
            key: '8',
            index: 8,
            name: '港口',
            id: 564536,
            type: '港口',
            department: '水路运输局',
            address: "水路运输局",
        },
        {
            key: '9',
            index: 9,
            name: '港口',
            id: 564536,
            type: '港口',
            department: '水路运输局',
            address: "水路运输局",
        },
        {
            key: '10',
            index: 10,
            name: '港口',
            id: 564536,
            type: '港口',
            department: '水路运输局',
            address: "水路运输局",
        },
        {
            key: '11',
            index: 11,
            name: '港口',
            id: 564536,
            type: '港口',
            department: '水路运输局',
            address: "水路运输局",
        },
        {
            key: '12',
            index: 12,
            name: '港口',
            id: 564536,
            type: '港口',
            department: '水路运输局',
            address: "水路运输局",
        },
        {
            key: '13',
            index: 13,
            name: '港口',
            id: 564536,
            type: '港口',
            department: '水路运输局',
            address: "水路运输局",
        },
        {
            key: '14',
            index: 14,
            name: '港口',
            id: 564536,
            type: '港口',
            department: '水路运输局',
            address: "水路运输局",
        },
        {
            key: '15',
            index: 15,
            name: '港口',
            id: 564536,
            type: '港口',
            department: '水路运输局',
            address: "水路运输局",
        },
    ];

    return (
        <div style={STYLE.Container}>
            <div style={STYLE.Container.Header}>
                <Breadcrumb style={STYLE.Container.Header.Breadcrumb}>
                    <Breadcrumb.Item><DoubleRightOutlined style={STYLE.Container.Header.Breadcrumb.Icon} />&emsp;数据资源</Breadcrumb.Item>
                    <Breadcrumb.Item>目录管理</Breadcrumb.Item>
                </Breadcrumb>
                <Search
                    placeholder="请输入关键词"
                    onSearch={onSearch}
                    style={STYLE.Container.Header.Search}
                />
            </div>
            <div style={STYLE.Container.Content}>
                <div style={STYLE.Container.Content.LeftContent}>
                    <Tree
                        // showLine
                        // showIcon={false}
                        onSelect={onSelect}
                        treeData={treeData}
                    />
                </div>
                <div style={STYLE.Container.Content.RightContent}>
                    <Table
                        columns={columns}
                        dataSource={data}
                        size={"small"}
                        pagination={{
                            hideOnSinglePage:true
                        }}
                    />
                </div>
            </div>
        </div>
    )
}