import React, { useState, useEffect } from 'react';
import { useNavigate } from 'react-router-dom'
import { Provider } from 'react-redux';
import { message, Layout, Menu, Button } from 'antd'
import Info from "./components/info"
import store from "../../store/store"
import RouterBeforeEach from '../../router/RouterBeforeEach.js'
import { API_queryMenu } from '@/api';
import { DatabaseOutlined, AppstoreAddOutlined, SettingOutlined, CodepenOutlined, MacCommandOutlined } from '@ant-design/icons'
const { Header, Content, Sider } = Layout;
import './index.css';
const STYLE = {
  Layout: {
    width: "100%",
    height: "100vh",
    backgroundImage: "url(../../public/img/4.png)",
    Header: {
      width: "100%",
      height: "80px",
      boxShadow: "2px 2px 3px black",
      backgroundImage: "url(../../public/img/5.png)",
      backgroundRepeat: "no-repeat",
      backgroundSize: "100% 100%",
      title: {
        width: "260px",
        fontSize: "30px",
        float: "left",
        color: "white",
        textAlign: "center",
        height: "80px",
        lineHeight: "80px",
        fontWeight: "700"
      },

    },
    Layout: {
      width: "100%",
      height: "calc(100% - 82px)",
      marginTop: "2px",
      Sider: {
        height: "100%",
        boxShadow: "2px 2px 3px black",
        backgroundImage: "url(../../public/img/5.png)",
        title: {
          width: "100%",
          height: "100px",
          padding: "10px 0px",
          color: "white",
          textAlign: "center",
          fontSize: "23px",
          fontWeight: "700"
        },
        Menu: {
          width: "100%",
          height: "calc(100% - 100px)",
          color: "white",
          background: "none",
          listStyleType: "none",
          transition: "background-color 0.3s ease 0s, min-width 0.3s ease 0s, max-width 0.3s cubic-bezier(0.645, 0.045, 0.355, 1) 0s",
          boxShadow: "2px 0 8px 0 rgb(29 35 41 / 5%)"
        }
      },
      Content: {
        width: "100%",
        height: "100%",
        padding: "20px"
      }
    }
  }
}

const data = [
  {
    label: '数据接入', path: 'sjjr',
    children: [
      { label: '文件接入', path: 'wjjr' },
      { label: '接口服务', path: 'jkfw' },
      { label: '数据探查', path: 'sjtc' },
    ]
  },
  {
    label: '数据处理', path: 'sjcl',
    children: [
      { label: '离线开发', path: 'lxkf' },
      { label: '实时开发', path: 'sskf' }
    ]
  }
]


const App = (() => {
  const [res, setRes] = useState(data);
  const [items, setItems] = useState([]);
  const navigate = useNavigate();

  const [selectKeys, setSelectKeys] = useState([]);
  const [openKeys, setOpenKeys] = useState([]);
  const [collapsed, setCollapsed] = useState(false);
  const [firstOpenKey, setFirstOpenKey] = useState([]);
  const icons = [<DatabaseOutlined />, <AppstoreAddOutlined />]
  const generateMenu = (data) => {
    let data_list = [];
    for (let i = 0; i < data.length; i++) {
      let obj = {};
      if (data[i].children && data[i].children.length) {
        obj = { label: data[i].label, key: data[i].path, icon: icons[i % icons.length], children: [] };
        obj.children = generateMenu(data[i].children);
      } else {
        obj = { label: data[i].label, key: data[i].path };
        data[i].label == '自由配置' ? obj.icon = <SettingOutlined /> :
          (data[i].label == '开发中心' ? obj.icon = <CodepenOutlined /> :
            ((data[i].label == '主题展示' ? obj.icon = <MacCommandOutlined /> : '')
            )
          )
      }
      data_list.push(obj);
    }
    return data_list;
  }

  useEffect(() => {
    // API_queryMenu({ "value": sessionStorage.getItem('username'), "type": "USER" }).then(res => {
    //   setItems(generateMenu(res));
    //   debugger;
    //   if (res.length > 0) {
    //     setFirstOpenKey([res[0].path]);
    //   }
    //   if ((!sessionStorage.getItem('selectKeys') && !sessionStorage.getItem('openKeys'))) {
    //     setSelectKeys([res[0].children ? res[0].children[0].path : res[0].path]);
    //     setOpenKeys([res[0].path]);
    //     sessionStorage.setItem('openKeys', [res[0].path]);
    //     sessionStorage.setItem('selectKeys', res[0].children ? [res[0].children[0].path] : [res[0].path]);
    //     navigate((sessionStorage.getItem('selectKeys') && sessionStorage.getItem('selectKeys')) ? sessionStorage.getItem('selectKeys') : res[0].children ? res[0].children[0].path : res[0].path);
    //   } else {
    //     let openKey = [];
    //     if (sessionStorage.getItem('openKeys')) {
    //       openKey = (sessionStorage.getItem('openKeys').indexOf(',') != -1) ? sessionStorage.getItem('openKeys').split(',') :
    //         (sessionStorage.getItem('openKeys').indexOf(',') == -1) ? [sessionStorage.getItem('openKeys')] :
    //           []
    //       sessionStorage.setItem('openKeys', openKey);
    //     } else {
    //       if (sessionStorage.getItem('openKeys') != '') {
    //         openKey = [res[0].path];
    //         sessionStorage.setItem('openKeys', openKey);
    //       }
    //     }
    //     setSelectKeys([(sessionStorage.getItem('selectKeys') && sessionStorage.getItem('selectKeys')) ? sessionStorage.getItem('selectKeys') : res[0].children ? res[0].children[0].path : res[0].path]);
    //     sessionStorage.setItem('selectKeys', [(sessionStorage.getItem('selectKeys') && sessionStorage.getItem('selectKeys')) ? sessionStorage.getItem('selectKeys') : res[0].children ? res[0].children[0].path : res[0].path]);
    //     setOpenKeys(openKey);
    //   }
    // }).catch(err => {
    //   message.warn(err);
    // });
    // sessionStorage.setItem("login", false);
    //     navigate("/login");
    //     sessionStorage.clear();
    setItems(generateMenu(data));
    if (res.length > 0) {
      setFirstOpenKey([res[0].path]);
    }
    if ((!sessionStorage.getItem('selectKeys') && !sessionStorage.getItem('openKeys'))) {
      setSelectKeys([res[0].children ? res[0].children[0].path : res[0].path]);
      setOpenKeys([res[0].path]);
      sessionStorage.setItem('openKeys', [res[0].path]);
      sessionStorage.setItem('selectKeys', res[0].children ? [res[0].children[0].path] : [res[0].path]);
      debugger
      navigate((sessionStorage.getItem('selectKeys') && sessionStorage.getItem('selectKeys')) ? sessionStorage.getItem('selectKeys') : res[0].children ? res[0].children[0].path : res[0].path);
    } else {
      let openKey = [];
      if (sessionStorage.getItem('openKeys')) {
        openKey = (sessionStorage.getItem('openKeys').indexOf(',') != -1) ? sessionStorage.getItem('openKeys').split(',') :
          (sessionStorage.getItem('openKeys').indexOf(',') == -1) ? [sessionStorage.getItem('openKeys')] :
            []
        sessionStorage.setItem('openKeys', openKey);
      } else {
        if (sessionStorage.getItem('openKeys') != '') {
          openKey = [res[0].path];
          sessionStorage.setItem('openKeys', openKey);
        }
      }
      setSelectKeys([(sessionStorage.getItem('selectKeys') && sessionStorage.getItem('selectKeys')) ? sessionStorage.getItem('selectKeys') : res[0].children ? res[0].children[0].path : res[0].path]);
      sessionStorage.setItem('selectKeys', [(sessionStorage.getItem('selectKeys') && sessionStorage.getItem('selectKeys')) ? sessionStorage.getItem('selectKeys') : res[0].children ? res[0].children[0].path : res[0].path]);
      setOpenKeys(openKey);
    }
  }, []);

  const onClick = (e, a) => {
    navigate(e.key);
    setSelectKeys([e.key]);
    setFirstOpenKey([e.keyPath[e.keyPath.length - 1]]);
    sessionStorage.setItem("selectKeys", [e.key]);
  };

  const toggleCollapsed = (value) => {
    setCollapsed(value);
    if (!value) {
      let openKey = [];
      if (sessionStorage.getItem('openKeys')) {
        openKey = (sessionStorage.getItem('openKeys').indexOf(',') != -1) ? sessionStorage.getItem('openKeys').split(',') :
          (sessionStorage.getItem('openKeys').indexOf(',') == -1) ? [sessionStorage.getItem('openKeys')] :
            []
        sessionStorage.setItem('openKeys', openKey);
      } else {
        if (sessionStorage.getItem('openKeys') != '') {
          openKey = firstOpenKey;
          sessionStorage.setItem('openKeys', openKey);
        }
      }
      setOpenKeys(openKey);
    }
  };

  const onOpenChange = (data) => {
    setOpenKeys(data);
    if (!collapsed) {
      sessionStorage.setItem("openKeys", data);
    }
  };




  return (
    <Layout style={STYLE.Layout}>
      <Header style={STYLE.Layout.Header}>
        <div style={STYLE.Layout.Header.title}>台州公安数智中枢</div>
        <Provider store={store}>
          <div style={{ float: "right" }}>
            <Info />
          </div>
        </Provider>
      </Header>

      <Layout className="site-layout" style={STYLE.Layout.Layout}>
        <Sider width={220} collapsible collapsed={collapsed} onCollapse={(value) => toggleCollapsed(value)} style={STYLE.Layout.Layout.Sider}>
          <Menu
            openKeys={openKeys}
            selectedKeys={selectKeys}
            mode="inline"
            items={items}
            style={STYLE.Layout.Layout.Sider.Menu}
            onClick={onClick}
            onOpenChange={onOpenChange}
          />
        </Sider>
        <Content style={STYLE.Layout.Layout.Content}>
          <RouterBeforeEach />
        </Content>
      </Layout>
    </Layout>
  )
})


export default App