import {GET, POST} from "../axios"

/**
 * 登录请求服务
 * @param username 
 * @param password 
 * @returns 
 */
export const API_Login = (username:string, password:string) => {
    return GET('api/api-auth/rest/user/login', {account: username, password: btoa(password)});
}


/**
 * 查询菜单列表
 * @param body 
 * @returns 
 */
export const API_queryMenu = (body) => {
    return POST('api/api-auth/rest/menu/queryList', body);
}

/**
 * 查询用户列表
 * @param body 
 * @returns 
 */
 export const API_queryUserList = (body) => {
    return GET('api/api-auth/rest/user/queryList', body);
}


/**
 * 新增用户
 * @param body 
 * @returns 
 */
export const API_addUser = (body) => {
    return POST('api/api-auth/rest/user/add', body);
}

/**
 * 编辑用户
 * @param body 
 * @returns 
 */
 export const API_updateUser = (body) => {
    return POST('api/api-auth/rest/user/updateInfo', body);
}

/**
 * 修改密码
 * @param body 
 * @returns 
 */
export const API_updatePassword = (params) => {
    return GET('api/api-auth/rest/user/updatePassword', null, { params });
}

/**
 * 删除用户
 * @param body 
 * @returns 
 */
export const API_removeUser = (body) => {
    return GET('api/api-auth/rest/user/remove', body);
}

/**
 * 查询角色列表
 * @param body 
 * @returns 
 */
export const API_queryRoleList = (body) => {
    return GET('api/api-auth/rest/role/queryList', body);
}

/**
 * 新增角色
 * @param body 
 * @returns 
 */
export const API_addRole = (body) => {
    return POST('api/api-auth/rest/role/add', body);
}

/**
 * 编辑角色
 * @param body 
 * @returns 
 */
export const API_updateRole = (body) => {
    return POST('api/api-auth/rest/role/updateInfo', body);
}

/**
 * 授予角色权限
 * @param body 
 * @returns 
 */
 export const API_grantMenu = (param,body) => {
    return POST(`api/api-auth/rest/role/grantMenu/${param}`, body);
}

/**
 * 删除角色
 * @param body 
 * @returns 
 */
export const API_removeRole = (body) => {
    return POST(`api/api-auth/rest/role/bulkRemove`, body);
}
