package com.zksy.szpt.controller;

import com.zksy.szpt.domain.ValidationGroups;
import com.zksy.szpt.domain.dto.AppStoreDTO;
import com.zksy.szpt.service.AppStoreService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "appKey管理")
@RequestMapping("/rest/appStore")
@RestController
public class AppStoreController {
    private final AppStoreService appStoreService;

    public AppStoreController(AppStoreService infApiSettingService) {
        this.appStoreService = infApiSettingService;
    }

    @ApiOperation(value = "根据appKey获取appSecret", notes = "根据appKey获取appSecret")
    @PostMapping("/getAppSecretByAppKey")
    public Object getAppSecretByAppKey(@RequestBody AppStoreDTO appStoreDTO) {
        return appStoreService.getAppSecretByAppKey("1");
    }

    @ApiOperation(value = "新增appKey", notes = "新增appKey")
    @PostMapping("/insertAppStore")
    public Integer insertAppStore(@RequestBody @Validated({ValidationGroups.Create.class}) AppStoreDTO appStoreDTO) {
        return appStoreService.insertAppStore(appStoreDTO);
    }

    @ApiOperation(value = "更新appKey", notes = "更新appKey")
    @PostMapping("/updateAppIdSecret")
    public Integer updateAppStore(@RequestBody @Validated({ValidationGroups.Update.class}) AppStoreDTO appStoreDTO) {
        return appStoreService.updateAppStore(appStoreDTO);
    }
}
