package com.zksy.szpt.config;

import com.zksy.szpt.filter.SignatureVerificationFilter;
import com.zksy.szpt.filter.SignatureVerificationFilter1;
import com.zksy.szpt.filter.SignatureVerificationFilter2;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Component
public class WebConfig implements WebMvcConfigurer {

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        // 多个拦截器组成一个拦截器链
//        InterceptorRegistration interceptorRegistration = registry.addInterceptor(signatureInterceptor).order(1);
        // addPathPatterns 用于添加拦截规则
//        interceptorRegistration.addPathPatterns("/**");
        // excludePathPatterns 用户排除拦截
        //排除swagger
//        interceptorRegistration.excludePathPatterns("/v2/**");
//        interceptorRegistration.excludePathPatterns("/webjars/**");
//        interceptorRegistration.excludePathPatterns("/swagger-resources/**");
//        interceptorRegistration.excludePathPatterns("/configuration/**");
//        //排除登录
//        interceptorRegistration.excludePathPatterns("/rest/user/login");
//        interceptorRegistration.excludePathPatterns("/rest/user/loginByToken");
//        registry.addInterceptor(logInterceptor).order(2);
    }

    /**
     * 静态资源配置
     *
     * @param registry
     */
    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/favicon.ico", "/demo_upload.html", "/images/favicon-32x32.png", "/images/favicon-16x16.png", "/excel/newsList.xlsx")
                .addResourceLocations("classpath:/static/");
        // 解决 swagger-ui.html 404报错
        registry.addResourceHandler("doc.html").addResourceLocations(
                "classpath:/META-INF/resources/");
        registry.addResourceHandler("/webjars/**").addResourceLocations(
                "classpath:/META-INF/resources/webjars/");
    }

    /**
     * 注册过滤器，这里注册的是自定义的签名验证过滤器，并且只会对/rest/*路径下的请求进行过滤
     *
     * @return
     */
    @Bean
    @ConditionalOnBean(name = "signatureVerificationFilter")
    public FilterRegistrationBean getFilter1Registration(@Qualifier("signatureVerificationFilter") SignatureVerificationFilter signatureVerificationFilter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter(signatureVerificationFilter);
        //设置过滤器名称和路径，在过滤器类写了的话，这里不用重复写
        filterRegistrationBean.setName("filter");
        filterRegistrationBean.addUrlPatterns("/rest/*");
        //设置过滤器执行顺序，数字越小，越早进行过滤，也可设置为负数
        filterRegistrationBean.setOrder(1);
        return filterRegistrationBean;
    }

    @Bean
    @ConditionalOnBean(name = "signatureVerificationFilter1")
    public FilterRegistrationBean getFilter1Registration(@Qualifier("signatureVerificationFilter1") SignatureVerificationFilter1 signatureVerificationFilter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter(signatureVerificationFilter);
        //设置过滤器名称和路径，在过滤器类写了的话，这里不用重复写
        filterRegistrationBean.setName("filter");
        filterRegistrationBean.addUrlPatterns("/rest/*");
        //设置过滤器执行顺序，数字越小，越早进行过滤，也可设置为负数
        filterRegistrationBean.setOrder(1);
        return filterRegistrationBean;
    }

    @Bean
    @ConditionalOnBean(name = "signatureVerificationFilter2")
    public FilterRegistrationBean getFilter1Registration(@Qualifier("signatureVerificationFilter2") SignatureVerificationFilter2 signatureVerificationFilter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter(signatureVerificationFilter);
        //设置过滤器名称和路径，在过滤器类写了的话，这里不用重复写
        filterRegistrationBean.setName("filter");
        filterRegistrationBean.addUrlPatterns("/rest/*");
        //设置过滤器执行顺序，数字越小，越早进行过滤，也可设置为负数
        filterRegistrationBean.setOrder(1);
        return filterRegistrationBean;
    }
}
