package com.zksy.szpt.config;

import com.zksy.szpt.util.SignatureUtil;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import java.util.ArrayList;
import java.util.List;


/**
 * Created by wcy on 2023/5/14.
 */
@Configuration
@EnableSwagger2
public class SwaggerConfig {

    @Bean
    public Docket createRestApi() {

        List<Parameter> pars = new ArrayList<>();
        Parameter param1 = new ParameterBuilder().name(SignatureUtil.APPID).description("appid").modelRef(new ModelRef("string")).parameterType("header").required(false).build();
        Parameter param2 = new ParameterBuilder().name(SignatureUtil.NONCE).description("nonce").modelRef(new ModelRef("string")).parameterType("header").required(false).build();
        Parameter param3 = new ParameterBuilder().name(SignatureUtil.TIMESTAMP).description("timestamp").modelRef(new ModelRef("string")).parameterType("header").required(false).build();
        Parameter param4 = new ParameterBuilder().name(SignatureUtil.SIGNATURE).description("signature").modelRef(new ModelRef("string")).parameterType("header").required(false).build();
        pars.add(param1);
        pars.add(param2);
        pars.add(param3);
        pars.add(param4);
        ApiInfo apiInfo = new ApiInfoBuilder()
            .title("模块服务接口文档")
            .description("服务接口文档，遵循RESTful API设计规范")
            .contact(new Contact("wcyuee", "www.baidu.com", "4"))
            .version("1.0").build();


        return new Docket(DocumentationType.SWAGGER_2)
//                .groupName("system")
                .apiInfo(apiInfo)
                .select()
                //以扫描包的方式
                .apis(RequestHandlerSelectors.basePackage("com.zksy.szpt.controller"))
                .paths(PathSelectors.any())
                .build()
                .globalOperationParameters(pars);
    }
}
