package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.CommonDelParamDTO;
import com.zksy.szpt.domain.dto.XxShxxyDwDTO;
import com.zksy.szpt.service.XxShxxyDwService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = "社会信息员队伍服务")
@RequestMapping("/rest/xxShxxyDw")
@RestController
@Validated
public class XxShxxyDwController {
    private final XxShxxyDwService service;

    public XxShxxyDwController(XxShxxyDwService service) {
        this.service = service;
    }


    @ApiOperation(value = "新增社会信息员队伍数据")
    @PostMapping("/add")
    public Integer XxShxxyDw(@RequestBody @Validated XxShxxyDwDTO dto) {
        return service.addXxShxxyDw(dto);
    }

    @ApiOperation(value = "修改社会信息员队伍数据")
    @PostMapping("/update")
    public Integer update(@RequestBody @Validated XxShxxyDwDTO dto) {
        return service.update(dto);
    }

    @ApiOperation(value = "根据信息员队伍ID删除社会信息员队伍数据")
    @PostMapping("/delete")
    public Integer delete(@RequestBody  @Validated CommonDelParamDTO dto) {
        return service.delete(dto);
    }

}
