package com.zksy.szpt.domain.dto;


import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

public class XxYjrwDTO {

    /**
     * 任务ID
     */
    @NotBlank(message = "任务ID不能为空")
    @ApiModelProperty(value = "任务ID")
    private String rwid;

    /**
     * 周期任务ID
     */
    @ApiModelProperty(value = "周期任务ID")
    private String taskId;

    /**
     * 任务类型;cslb=3211
     */
    @ApiModelProperty(value = "任务类型('11':'信息收集','12':'风险排查','13':'矛盾化解','14':'平安宣传','15':'救援救助','16':'重点帮教')")
    private String rwlx;

    /**
     * 任务标题
     */
    @NotBlank(message = "任务标题不能为空")
    @ApiModelProperty(value = "任务标题")
    private String rwbt;

    /**
     * 任务内容;
     */
    @NotBlank(message = "任务内容不能为空")
    @ApiModelProperty(value = "任务内容")
    private String rwnr;

    /**
     * 人均奖励积分
     */
    @ApiModelProperty(value = "人均奖励积分")
    private Long rjjljf;

    /**
     * 工作人数
     */
    @NotNull(message = "工作人数不能为空")
    @ApiModelProperty(value = "工作人数")
    private Long gzrs;

    /**
     * 完成人数
     */
    @NotNull(message = "完成人数不能为空")
    @ApiModelProperty(value = "完成人数")
    private Long wcrs;

    /**
     * 任务起始日期
     */
    @ApiModelProperty(value = "任务起始日期")
    private Date rwqsrq;

    /**
     * 任务截止日期
     */
    @ApiModelProperty(value = "任务截止日期")
    private Date rwjzrq;

    /**
     * 时间模式（1:单次；2:周期；3:间隔；）
     */
    @ApiModelProperty(value = "时间模式（1:单次；2:周期；3:间隔；）")
    private Integer timePattern;

    /**
     * 周期任务id
     */
    @ApiModelProperty(value = "周期任务id")
    private String scheduleId;

    /**
     * 审核模式（0:审核；1:无需审核）
     */
    @NotNull(message = "审核模式不能为空")
    @ApiModelProperty(value = "审核模式（0:审核；1:无需审核）")
    private Integer sfsh;

    /**
     * 发表范围
     */
    @ApiModelProperty(value = "发表范围")
    private String fbfw;

    /**
     * 发表范围编码
     */
    @ApiModelProperty(value = "发表范围编码")
    private String fbfwbm;

    /**
     * 发布人id
     */
    @ApiModelProperty(value = "发布人id")
    private String fbrid;

    /**
     * 发布人姓名
     */
    @ApiModelProperty(value = "发布人姓名")
    private String fbrxm;

    /**
     * 发布时间
     */
    @ApiModelProperty(value = "发布时间")
    private Date fbsj;

    /**
     * 运营单位ID
     */
    @ApiModelProperty(value = "运营单位ID")
    private String mchid;

    /**
     * 任务状态;cslb=3213
     */
    @ApiModelProperty(value = "任务状态('0':'未开始','1':'进行中','2':'已结束')")
    private String rwzt;

    /**
     * 图片
     */
    @ApiModelProperty(value = "图片")
    private String pictureUrls;

    public String getRwid() {
        return rwid;
    }

    public void setRwid(String rwid) {
        this.rwid = rwid == null ? null : rwid.trim();
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId == null ? null : taskId.trim();
    }

    public String getRwlx() {
        return rwlx;
    }

    public void setRwlx(String rwlx) {
        this.rwlx = rwlx == null ? null : rwlx.trim();
    }

    public String getRwbt() {
        return rwbt;
    }

    public void setRwbt(String rwbt) {
        this.rwbt = rwbt == null ? null : rwbt.trim();
    }

    public String getRwnr() {
        return rwnr;
    }

    public void setRwnr(String rwnr) {
        this.rwnr = rwnr == null ? null : rwnr.trim();
    }

    public Long getRjjljf() {
        return rjjljf;
    }

    public void setRjjljf(Long rjjljf) {
        this.rjjljf = rjjljf;
    }

    public Long getGzrs() {
        return gzrs;
    }

    public void setGzrs(Long gzrs) {
        this.gzrs = gzrs;
    }

    public Long getWcrs() {
        return wcrs;
    }

    public void setWcrs(Long wcrs) {
        this.wcrs = wcrs;
    }

    public Date getRwqsrq() {
        return rwqsrq;
    }

    public void setRwqsrq(Date rwqsrq) {
        this.rwqsrq = rwqsrq;
    }

    public Date getRwjzrq() {
        return rwjzrq;
    }

    public void setRwjzrq(Date rwjzrq) {
        this.rwjzrq = rwjzrq;
    }

    public Integer getTimePattern() {
        return timePattern;
    }

    public void setTimePattern(Integer timePattern) {
        this.timePattern = timePattern;
    }

    public String getScheduleId() {
        return scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId == null ? null : scheduleId.trim();
    }

    public Integer getSfsh() {
        return sfsh;
    }

    public void setSfsh(Integer sfsh) {
        this.sfsh = sfsh;
    }

    public String getFbfw() {
        return fbfw;
    }

    public void setFbfw(String fbfw) {
        this.fbfw = fbfw == null ? null : fbfw.trim();
    }

    public String getFbfwbm() {
        return fbfwbm;
    }

    public void setFbfwbm(String fbfwbm) {
        this.fbfwbm = fbfwbm == null ? null : fbfwbm.trim();
    }

    public String getFbrid() {
        return fbrid;
    }

    public void setFbrid(String fbrid) {
        this.fbrid = fbrid == null ? null : fbrid.trim();
    }

    public String getFbrxm() {
        return fbrxm;
    }

    public void setFbrxm(String fbrxm) {
        this.fbrxm = fbrxm == null ? null : fbrxm.trim();
    }

    public Date getFbsj() {
        return fbsj;
    }

    public void setFbsj(Date fbsj) {
        this.fbsj = fbsj;
    }

    public String getMchid() {
        return mchid;
    }

    public void setMchid(String mchid) {
        this.mchid = mchid == null ? null : mchid.trim();
    }

    public String getRwzt() {
        return rwzt;
    }

    public void setRwzt(String rwzt) {
        this.rwzt = rwzt == null ? null : rwzt.trim();
    }


    public String getPictureUrls() {
        return pictureUrls;
    }

    public void setPictureUrls(String pictureUrls) {
        this.pictureUrls = pictureUrls == null ? null : pictureUrls.trim();
    }
}