package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.XxShxxyDTO;
import com.zksy.szpt.domain.dto.XxShxxyDwDTO;
import com.zksy.szpt.domain.dto.XxYjrwDTO;
import com.zksy.szpt.service.XxShxxyDwService;
import com.zksy.szpt.service.XxShxxyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = "社会信息员服务")
@RequestMapping("/rest/xxShxxy")
@RestController
@Validated
public class XxShxxyController {
    private final XxShxxyService service;

    public XxShxxyController(XxShxxyService service) {
        this.service = service;
    }


    @ApiOperation(value = "新增社会信息员信息数据")
    @PostMapping("/add")
    public Integer addXxShxxy(@RequestBody @Validated XxShxxyDTO dto) {
        return service.addXxShxxy(dto);
    }


    @ApiOperation(value = "修改社会信息员数据")
    @PostMapping("/update")
    public Integer update(@RequestBody @Validated XxShxxyDTO dto) {
        return service.update(dto);
    }

    @ApiOperation(value = "删除社会信息员数据")
    @PostMapping("/delete")
    public Integer delete(@RequestBody  @Validated CommonDelDTO dto) {
        return service.delete(dto);
    }

}
