package com.zksy.szpt.controller;

import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptGdSbxxDTO;
import com.zksy.szpt.service.SzptGdSbxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Api(tags = "新增服务")
@RequestMapping("/rest/index")
@RestController
@Validated
public class SzptGdSbxxController {
    private final SzptGdSbxxService szptGdSbxxService;

    public SzptGdSbxxController(SzptGdSbxxService szptGdSbxxService) {
        this.szptGdSbxxService = szptGdSbxxService;
    }

    @ApiOperation(value="新增设备信息数据")
    @PostMapping("/addSzptGdSbxx")
    public Integer addSzptGdSbxx(@RequestBody @Validated SzptGdSbxxDTO szptGdSbxxDTO){
        return szptGdSbxxService.addSzptGdSbxx(szptGdSbxxDTO);
    }

    @ApiOperation(value="编辑设备信息数据")
    @PostMapping("/updateSzptGdSbxx")
    public Integer updateSzptGdSbxx(@RequestBody @Validated SzptGdSbxxDTO szptGdSbxxDTO){
        return szptGdSbxxService.updateSzptGdSbxx(szptGdSbxxDTO);
    }

    @ApiOperation(value = "删除设备信息数据")
    @PostMapping("/deleteSzptGdSbxx")
    public Integer deleteSzptGdSbxx(@RequestBody @Validated CommonDelDTO commonDelDTO) {
        return szptGdSbxxService.deleteSzptGdSbxx(commonDelDTO);
    }
}
