package com.zksy.szpt.controller;

import com.zksy.szpt.domain.PageInfo;
import com.zksy.szpt.domain.bo.SzptClockInRulesBO;
import com.zksy.szpt.domain.dto.*;
import com.zksy.szpt.service.SzptClockInRulesService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = "边缘性场所、娱乐场所、旅馆酒店从业人员打卡规则")
@RequestMapping("/rest/index")
@RestController
@Validated
public class SzptClockInRulesController {
    private final SzptClockInRulesService szptClockInRulesService;

    public SzptClockInRulesController(SzptClockInRulesService szptClockInRulesService) {
        this.szptClockInRulesService = szptClockInRulesService;
    }

    @ApiOperation(value="查询边缘性场所、娱乐场所、旅馆酒店从业人员打卡规则数据")
    @PostMapping("/querySzptClockInRules")
    public PageInfo<SzptClockInRulesBO> querySzptClockInRules(@RequestBody @Validated SzptClockInRulesQueryDTO szptClockInRulesQueryDTO){
        return szptClockInRulesService.querySzptClockInRules(szptClockInRulesQueryDTO);
    }

    @ApiOperation(value="新增边缘性场所、娱乐场所、旅馆酒店从业人员打卡规则数据")
    @PostMapping("/addSzptClockInRules")
    public Integer addSzptClockInRules(@RequestBody @Validated SzptClockInRulesDTO szptClockInRulesDTO){
        return szptClockInRulesService.addSzptClockInRules(szptClockInRulesDTO);
    }

    @ApiOperation(value="编辑边缘性场所、娱乐场所、旅馆酒店从业人员打卡规则数据")
    @PostMapping("/updateSzptClockInRules")
    public Integer updateSzptClockInRules(@RequestBody @Validated SzptClockInRulesDTO szptClockInRulesDTO){
        return szptClockInRulesService.updateSzptClockInRules(szptClockInRulesDTO);
    }

    @ApiOperation(value = "删除边缘性场所、娱乐场所、旅馆酒店从业人员打卡规则数据")
    @PostMapping("/deleteSzptClockInRules")
    public Integer deleteSzptClockInRules(@RequestBody @Validated CommonDelIntDTO commonDelIntDTO) {
        return szptClockInRulesService.deleteSzptClockInRules(commonDelIntDTO);
    }
}
