package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zksy.szpt.domain.dto.AppStoreDTO;
import com.zksy.szpt.domain.po.AppStore;
import com.zksy.szpt.mapper.AppStoreMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class AppStoreService {
    private final AppStoreMapper appStoreMapper;

    public AppStoreService(AppStoreMapper appStoreMapper) {
        this.appStoreMapper = appStoreMapper;
    }


    public String getAppSecretByAppKey(String appKey) {
        LambdaQueryWrapper<AppStore> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(AppStore::getAppKey, appKey);
        List<AppStore> tbAppStorePOList = appStoreMapper.selectList(queryWrapper);
        if (tbAppStorePOList != null && !tbAppStorePOList.isEmpty()) {
            return tbAppStorePOList.get(0).getAppSecret();
        }
        return null;
    }

    public Integer insertAppStore(AppStoreDTO appStoreDTO) {
        AppStore appStore = BeanMapperUtil.map(appStoreDTO, AppStore.class);
        return appStoreMapper.insert(appStore);
    }

    public AppStore getAppSecretInfo(String appKey) {
        LambdaQueryWrapper<AppStore> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(AppStore::getAppKey, appKey);
        List<AppStore> tbAppStorePOList = appStoreMapper.selectList(queryWrapper);
        if (tbAppStorePOList != null && !tbAppStorePOList.isEmpty()) {
            return tbAppStorePOList.get(0);
        }
        return null;
    }

    public Integer updateAppStore(AppStoreDTO appStoreDTO) {
        AppStore appStore = BeanMapperUtil.map(appStoreDTO, AppStore.class);
        return appStoreMapper.update(appStore, new LambdaQueryWrapper<AppStore>().eq(AppStore::getAppKey, appStore.getAppKey()));
    }
}
