package com.zksy.szpt.config;

import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.TopLevelClass;

import java.util.List;

/**
 * 自定义 MyBatis Generator 插件：
 * 将数据库表注释添加到实体类的类级 JavaDoc 上。mysql的url需要加useInformationSchema=true
 * 表字段注释加到实体类属性上。
 */
public class TableRemarksPlugin extends PluginAdapter {

    @Override
    public boolean validate(List<String> warnings) {
        // 必须实现 validate 方法，返回 true 表示插件可用
        return true;
    }

    /**
     * 为实体类添加表注释
     */
    @Override
    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        // 获取数据库表的注释
        String tableRemarks = introspectedTable.getRemarks();

        if (tableRemarks != null && !tableRemarks.isEmpty()) {
            // 添加类级 JavaDoc 注释
            topLevelClass.addJavaDocLine("/**");
            topLevelClass.addJavaDocLine(" * " + tableRemarks);
            topLevelClass.addJavaDocLine(" */");
        }

        return true;
    }

    /**
     * 为实体类字段添加字段注释。前面使用了DefaultCommentGenerator方法，因此这里可以不用。
     */
    @Override
    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass,
                                       IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable,
                                       ModelClassType modelClassType) {
        // 获取数据库字段的注释
        String columnRemarks = introspectedColumn.getRemarks();

        if (columnRemarks != null && !columnRemarks.isEmpty()) {
            // 添加字段 JavaDoc 注释。前面使用了DefaultCommentGenerator方法，因此这里可以不用。
//            field.addJavaDocLine("/**");
//            field.addJavaDocLine(" * " + columnRemarks);
//            field.addJavaDocLine(" */");
        }

        return true;
    }
}
