package com.zksy.szpt.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.zksy.szpt.domain.dto.CommonDelDTO;
import com.zksy.szpt.domain.dto.SzptXyzhDkxxDTO;
import com.zksy.szpt.domain.po.SzptXyzhDkxx;
import com.zksy.szpt.mapper.SzptXyzhDkxxMapper;
import com.zksy.szpt.util.BeanMapperUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class SzptXyzhDkxxService {
    @Resource
    private SzptXyzhDkxxMapper szptXyzhDkxxMapper;

    public Integer addSzptXyzhDkxx(SzptXyzhDkxxDTO szptXyzhDkxxDTO) {
        SzptXyzhDkxx szptXyzhDkxx = BeanMapperUtil.map(szptXyzhDkxxDTO, SzptXyzhDkxx.class);
        return szptXyzhDkxxMapper.insert(szptXyzhDkxx);
    }

    public Integer updateSzptXyzhDkxx(SzptXyzhDkxxDTO szptXyzhDkxxDTO) {
        SzptXyzhDkxx szptXyzhDkxx = BeanMapperUtil.map(szptXyzhDkxxDTO, SzptXyzhDkxx.class);
        LambdaUpdateWrapper<SzptXyzhDkxx> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(SzptXyzhDkxx::getDklsid, szptXyzhDkxx.getDklsid());
        return szptXyzhDkxxMapper.update(szptXyzhDkxx,wrapper);
    }

    public Integer deleteSzptXyzhDkxx(CommonDelDTO commonDelDTO) {
        LambdaQueryWrapper<SzptXyzhDkxx> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(SzptXyzhDkxx::getDklsid, commonDelDTO.getIds());
        return szptXyzhDkxxMapper.delete(wrapper);
    }
}
